/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.util.Assert;

public class AssignValue
extends AbstractSegment
implements Assignment {
    private final Column column;
    private final Expression value;

    private AssignValue(Column column, Expression value) {
        super(column, value);
        this.column = column;
        this.value = value;
    }

    public static AssignValue create(Column target, Expression value) {
        Assert.notNull((Object)target, (String)"Target column must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new AssignValue(target, value);
    }

    public Column getColumn() {
        return this.column;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.column) + " = " + String.valueOf(this.value);
    }
}

