/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.UncategorizedSolrException;
import org.springframework.data.solr.core.CollectionCallback;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.QueryParsers;
import org.springframework.data.solr.core.RequestMethod;
import org.springframework.data.solr.core.ResultHelper;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.AbstractQueryDecorator;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.Cursor;
import org.springframework.data.solr.core.query.result.DelegatingCursor;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.GroupPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.SolrResultPage;
import org.springframework.data.solr.core.query.result.SpellcheckQueryResult;
import org.springframework.data.solr.core.query.result.StatsPage;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.data.solr.core.query.result.TermsResultPage;
import org.springframework.data.solr.core.schema.DefaultSchemaOperations;
import org.springframework.data.solr.core.schema.SchemaOperations;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.data.solr.server.support.MulticoreSolrClientFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SolrTemplate
implements SolrOperations,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrTemplate.class);
    private static final PersistenceExceptionTranslator EXCEPTION_TRANSLATOR = new SolrExceptionTranslator();
    private final QueryParsers queryParsers = new QueryParsers();
    private MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;
    private ApplicationContext applicationContext;
    private String solrCore;
    private final RequestMethod defaultRequestMethod;
    private static final List<String> ITERABLE_CLASSES = new ArrayList<String>(){
        {
            this.add(List.class.getName());
            this.add(Collection.class.getName());
            this.add(Iterator.class.getName());
        }
    };
    private SolrClientFactory solrClientFactory;
    private SolrConverter solrConverter;
    private Set<SolrPersistentEntitySchemaCreator.Feature> schemaCreationFeatures;

    public SolrTemplate(SolrClient solrClient) {
        this(solrClient, null);
    }

    public SolrTemplate(SolrClient solrClient, String core) {
        this(new HttpSolrClientFactory(solrClient, core));
        this.solrCore = core;
    }

    public SolrTemplate(SolrClient solrClient, String core, RequestMethod requestMethod) {
        this((SolrClientFactory)new HttpSolrClientFactory(solrClient, core), requestMethod);
        this.solrCore = core;
    }

    public SolrTemplate(SolrClientFactory solrClientFactory) {
        this(solrClientFactory, (SolrConverter)null);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, String defaultCore) {
        this(solrClientFactory, (SolrConverter)null);
        this.solrCore = defaultCore;
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, RequestMethod requestMethod) {
        this(solrClientFactory, null, requestMethod);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, SolrConverter solrConverter) {
        this(solrClientFactory, solrConverter, RequestMethod.GET);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, SolrConverter solrConverter, RequestMethod defaultRequestMethod) {
        Assert.notNull((Object)solrClientFactory, (String)"SolrClientFactory must not be 'null'.");
        this.solrClientFactory = solrClientFactory;
        this.defaultRequestMethod = defaultRequestMethod != null ? defaultRequestMethod : RequestMethod.GET;
    }

    @Override
    public <T> T execute(SolrCallback<T> action) {
        Assert.notNull(action, (String)"SolrCallback must not be null!");
        try {
            SolrClient solrClient = this.getSolrClient();
            return action.doInSolr(solrClient);
        }
        catch (Exception e) {
            DataAccessException resolved = SolrTemplate.getExceptionTranslator().translateExceptionIfPossible(new RuntimeException(e.getMessage(), e));
            throw resolved == null ? new UncategorizedSolrException(e.getMessage(), e) : resolved;
        }
    }

    @Override
    public <T> T execute(String collection, CollectionCallback<T> action) {
        Assert.notNull(action, (String)"Action must not be null!");
        try {
            SolrClient solrClient = null;
            solrClient = StringUtils.hasText((String)collection) ? (this.solrClientFactory instanceof MulticoreSolrClientFactory ? this.solrClientFactory.getSolrClient() : this.solrClientFactory.getSolrClient(collection)) : this.getSolrClient();
            return action.doInSolr(solrClient, collection);
        }
        catch (Exception e) {
            DataAccessException resolved = SolrTemplate.getExceptionTranslator().translateExceptionIfPossible(e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e.getMessage(), e));
            throw resolved == null ? new UncategorizedSolrException(e.getMessage(), e) : resolved;
        }
    }

    @Override
    public SolrPingResponse ping() {
        return this.execute(new SolrCallback<SolrPingResponse>(){

            @Override
            public SolrPingResponse doInSolr(SolrClient solrClient) throws SolrServerException, IOException {
                return solrClient.ping();
            }
        });
    }

    @Override
    public long count(SolrDataQuery query) {
        return this.count(query, this.getDefaultRequestMethod());
    }

    @Override
    public long count(String collectionName, SolrDataQuery query) {
        return this.count(collectionName, query, this.getDefaultRequestMethod());
    }

    @Override
    public long count(SolrDataQuery query, RequestMethod method) {
        return this.count(null, query, method);
    }

    @Override
    public long count(String collectionName, final SolrDataQuery query, final RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method must not be 'null'.");
        return this.execute(collectionName, new CollectionCallback<Long>(){

            @Override
            public Long doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                SolrQuery solrQuery = SolrTemplate.this.queryParsers.getForClass(query.getClass()).constructSolrQuery(query);
                solrQuery.setStart(Integer.valueOf(0));
                solrQuery.setRows(Integer.valueOf(0));
                return StringUtils.hasText((String)collection) ? solrClient.query(collection, (SolrParams)solrQuery, SolrTemplate.this.getSolrRequestMethod(method)).getResults().getNumFound() : solrClient.query((SolrParams)solrQuery, SolrTemplate.this.getSolrRequestMethod(method)).getResults().getNumFound();
            }
        });
    }

    @Override
    public UpdateResponse saveBean(Object obj) {
        return this.saveBean(obj, -1);
    }

    @Override
    public UpdateResponse saveBean(String collectionName, Object obj) {
        return this.saveBean(collectionName, obj, -1);
    }

    @Override
    public UpdateResponse saveBean(Object objectToAdd, int commitWithinMs) {
        return this.saveBean(this.getSolrCoreOrBeanCollection(ClassUtils.getUserClass((Object)objectToAdd)), objectToAdd, commitWithinMs);
    }

    @Override
    public UpdateResponse saveBean(String collectionName, final Object objectToAdd, final int commitWithinMs) {
        this.assertNoCollection(objectToAdd);
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.add(collection, SolrTemplate.this.convertBeanToSolrInputDocument(objectToAdd), commitWithinMs) : solrClient.add(SolrTemplate.this.convertBeanToSolrInputDocument(objectToAdd), commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveBeans(Collection<?> beans) {
        return this.saveBeans(beans, -1);
    }

    @Override
    public UpdateResponse saveBeans(String collectionName, Collection<?> beans) {
        return this.saveBeans(collectionName, beans, -1);
    }

    @Override
    public UpdateResponse saveBeans(Collection<?> beansToAdd, int commitWithinMs) {
        return this.saveBeans(this.getSolrCoreOrBeanCollection(ClassUtils.getUserClass(beansToAdd.iterator().next())), beansToAdd, commitWithinMs);
    }

    @Override
    public UpdateResponse saveBeans(String collectionName, final Collection<?> beansToAdd, final int commitWithinMs) {
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.add(collection, SolrTemplate.this.convertBeansToSolrInputDocuments(beansToAdd), commitWithinMs) : solrClient.add(SolrTemplate.this.convertBeansToSolrInputDocuments(beansToAdd), commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveDocument(SolrInputDocument document) {
        return this.saveDocument(document, -1);
    }

    @Override
    public UpdateResponse saveDocument(String collectionName, SolrInputDocument document) {
        return this.saveDocument(collectionName, document, -1);
    }

    @Override
    public UpdateResponse saveDocument(SolrInputDocument documentToAdd, int commitWithinMs) {
        return this.saveDocument(null, documentToAdd, commitWithinMs);
    }

    @Override
    public UpdateResponse saveDocument(String collectionName, final SolrInputDocument documentToAdd, final int commitWithinMs) {
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.add(collection, documentToAdd, commitWithinMs) : solrClient.add(documentToAdd, commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveDocuments(Collection<SolrInputDocument> documents) {
        return this.saveDocuments(documents, -1);
    }

    @Override
    public UpdateResponse saveDocuments(String collectionName, Collection<SolrInputDocument> documents) {
        return this.saveDocuments(collectionName, documents, -1);
    }

    @Override
    public UpdateResponse saveDocuments(final Collection<SolrInputDocument> documentsToAdd, final int commitWithinMs) {
        return this.execute(new SolrCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient) throws SolrServerException, IOException {
                return solrClient.add(documentsToAdd, commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse saveDocuments(String collectionName, final Collection<SolrInputDocument> documentsToAdd, final int commitWithinMs) {
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.add(collection, documentsToAdd, commitWithinMs) : solrClient.add(documentsToAdd, commitWithinMs);
            }
        });
    }

    @Override
    public UpdateResponse delete(SolrDataQuery query) {
        return this.delete(null, query);
    }

    @Override
    public UpdateResponse delete(String collectionName, SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        final String queryString = this.queryParsers.getForClass(query.getClass()).getQueryString(query);
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.deleteByQuery(collection, queryString) : solrClient.deleteByQuery(queryString);
            }
        });
    }

    @Override
    public UpdateResponse deleteById(String id) {
        return this.deleteById(null, id);
    }

    @Override
    public UpdateResponse deleteById(String collectionName, final String id) {
        Assert.notNull((Object)id, (String)"Cannot delete 'null' id.");
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.deleteById(collection, id) : solrClient.deleteById(id);
            }
        });
    }

    @Override
    public UpdateResponse deleteById(Collection<String> ids) {
        return this.deleteById(null, ids);
    }

    @Override
    public UpdateResponse deleteById(String collectionName, Collection<String> ids) {
        Assert.notNull(ids, (String)"Cannot delete 'null' collection.");
        final ArrayList<String> toBeDeleted = new ArrayList<String>(ids);
        return this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.deleteById(collection, toBeDeleted) : solrClient.deleteById(toBeDeleted);
            }
        });
    }

    @Override
    public <T> T queryForObject(Query query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> T queryForObject(String collectionName, Query query, Class<T> clazz) {
        return this.queryForObject(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> T queryForObject(Query query, Class<T> clazz, RequestMethod method) {
        return this.queryForObject(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> T queryForObject(String collectionName, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        query.setPageRequest((Pageable)new PageRequest(0, 1));
        QueryResponse response = this.querySolr(collectionName, query, clazz, method);
        if (response.getResults().size() > 0) {
            if (response.getResults().size() > 1) {
                LOGGER.warn("More than 1 result found for singe result query ('{}'), returning first entry in list", (Object)query);
            }
            return this.convertSolrDocumentListToBeans(response.getResults(), clazz).get(0);
        }
        return null;
    }

    private <T> SolrResultPage<T> doQueryForPage(String collectionName, Query query, Class<T> clazz, RequestMethod requestMethod) {
        QueryResponse response = null;
        QueryParserBase.NamedObjectsQuery namedObjectsQuery = new QueryParserBase.NamedObjectsQuery(query);
        response = this.querySolr(collectionName, namedObjectsQuery, clazz, requestMethod != null ? requestMethod : this.getDefaultRequestMethod());
        Map<String, Object> objectsName = namedObjectsQuery.getNamesAssociation();
        return this.createSolrResultPage(query, clazz, response, objectsName);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(Query query, Class<T> clazz) {
        return this.queryForPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(String collectionName, Query query, Class<T> clazz) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        return this.doQueryForPage(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T, S extends Page<T>> S query(Query query, Class<T> clazz) {
        return this.query(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T, S extends Page<T>> S query(String collectionName, Query query, Class<T> clazz) {
        return this.query(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T, S extends Page<T>> S query(Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull(clazz, (String)"Method must not be 'null'.");
        return (S)this.doQueryForPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T, S extends Page<T>> S query(String collectionName, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull(clazz, (String)"Method must not be 'null'.");
        return (S)this.doQueryForPage(collectionName, query, clazz, method);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(Query query, Class<T> clazz, RequestMethod method) {
        return this.queryForPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(String collectionName, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collectionName, query, clazz, method);
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(Query query, Class<T> clazz) {
        return this.queryForGroupPage(query, clazz, RequestMethod.GET);
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(String collectionName, Query query, Class<T> clazz) {
        return this.queryForGroupPage(collectionName, query, clazz, RequestMethod.GET);
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(Query query, Class<T> clazz, RequestMethod method) {
        return this.queryForGroupPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(String collectionName, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collectionName, query, clazz, method);
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(Query query, Class<T> clazz) {
        return this.queryForStatsPage(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(String collectionName, Query query, Class<T> clazz) {
        return this.queryForStatsPage(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(Query query, Class<T> clazz, RequestMethod method) {
        return this.queryForStatsPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(String collectionName, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collectionName, query, clazz, method);
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(FacetQuery query, Class<T> clazz) {
        return this.queryForFacetPage(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(String collectionName, FacetQuery query, Class<T> clazz) {
        return this.queryForFacetPage(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(FacetQuery query, Class<T> clazz, RequestMethod method) {
        return this.queryForFacetPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(String collectionName, FacetQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsFacetQuery namedObjectsQuery = new QueryParserBase.NamedObjectsFacetQuery(query);
        return this.createSolrResultPage(query, clazz, this.querySolr(collectionName, namedObjectsQuery, clazz, method), namedObjectsQuery.getNamesAssociation());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery query, Class<T> clazz) {
        return this.queryForHighlightPage(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(String collectionName, HighlightQuery query, Class<T> clazz) {
        return this.queryForHighlightPage(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(HighlightQuery query, Class<T> clazz, RequestMethod method) {
        return this.queryForHighlightPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(String collectionName, HighlightQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsHighlightQuery namedObjectsQuery = new QueryParserBase.NamedObjectsHighlightQuery(query);
        QueryResponse response = this.querySolr(collectionName, namedObjectsQuery, clazz, this.getDefaultRequestMethod());
        return this.createSolrResultPage(query, clazz, response, namedObjectsQuery.getNamesAssociation());
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(FacetAndHighlightQuery query, Class<T> clazz) {
        return this.queryForFacetAndHighlightPage(query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String collectionName, FacetAndHighlightQuery query, Class<T> clazz) {
        return this.queryForFacetAndHighlightPage(collectionName, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(FacetAndHighlightQuery query, Class<T> clazz, RequestMethod method) {
        return this.queryForFacetAndHighlightPage(this.getSolrCoreOrBeanCollection(clazz), query, clazz, method);
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String collectionName, FacetAndHighlightQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsFacetAndHighlightQuery namedObjectsFacetAndHighlightQuery = new QueryParserBase.NamedObjectsFacetAndHighlightQuery(query);
        QueryResponse response = this.querySolr(collectionName, namedObjectsFacetAndHighlightQuery, clazz, method);
        Map<String, Object> objectsName = namedObjectsFacetAndHighlightQuery.getNamesAssociation();
        return this.createSolrResultPage(query, clazz, response, objectsName);
    }

    private <T> SolrResultPage<T> createSolrResultPage(Query query, Class<T> clazz, QueryResponse response, Map<String, Object> objectsName) {
        List<T> beans = this.convertQueryResponseToBeans(response, clazz);
        SolrDocumentList results = response.getResults();
        long numFound = results == null ? 0L : results.getNumFound();
        Float maxScore = results == null ? null : results.getMaxScore();
        Pageable pageRequest = query.getPageRequest();
        SolrResultPage<T> page = new SolrResultPage<T>(beans, pageRequest, numFound, maxScore);
        page.setFieldStatsResults(ResultHelper.convertFieldStatsInfoToFieldStatsResultMap(response.getFieldStatsInfo()));
        page.setGroupResults(ResultHelper.convertGroupQueryResponseToGroupResultMap(query, objectsName, response, this, clazz));
        if (query instanceof HighlightQuery) {
            ResultHelper.convertAndAddHighlightQueryResponseToResultPage(response, page);
        }
        if (query instanceof FacetQuery) {
            page.setFacetQueryResultPage(ResultHelper.convertFacetQueryResponseToFacetQueryResult((FacetQuery)query, response));
            page.addAllFacetFieldResultPages(ResultHelper.convertFacetQueryResponseToFacetPageMap((FacetQuery)query, response));
            page.addAllFacetPivotFieldResult(ResultHelper.convertFacetQueryResponseToFacetPivotMap((FacetQuery)query, response));
            page.addAllRangeFacetFieldResultPages(ResultHelper.convertFacetQueryResponseToRangeFacetPageMap((FacetQuery)query, response));
        }
        if (query.getSpellcheckOptions() != null) {
            Map<String, List<SpellcheckQueryResult.Alternative>> suggestions = ResultHelper.extreactSuggestions(response);
            for (Map.Entry<String, List<SpellcheckQueryResult.Alternative>> entry : suggestions.entrySet()) {
                page.addSuggestions(entry.getKey(), entry.getValue());
            }
        }
        return page;
    }

    @Override
    public TermsPage queryForTermsPage(TermsQuery query) {
        return this.queryForTermsPage(query, this.getDefaultRequestMethod());
    }

    @Override
    public TermsPage queryForTermsPage(String collectionName, TermsQuery query) {
        return this.queryForTermsPage(collectionName, query, this.getDefaultRequestMethod());
    }

    @Override
    public TermsPage queryForTermsPage(TermsQuery query, RequestMethod method) {
        return this.queryForTermsPage(null, query, method);
    }

    @Override
    public TermsPage queryForTermsPage(String collectionName, TermsQuery query, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        QueryResponse response = this.querySolr(collectionName, query, null, method);
        TermsResultPage page = new TermsResultPage();
        page.addAllTerms(ResultHelper.convertTermsQueryResponseToTermsMap(response));
        return page;
    }

    final QueryResponse querySolr(String collectionName, SolrDataQuery query, Class<?> clazz) {
        return this.querySolr(collectionName, query, clazz, this.defaultRequestMethod);
    }

    final QueryResponse querySolr(String collectionName, SolrDataQuery query, Class<?> clazz, RequestMethod requestMethod) {
        SolrPersistentEntity persistedEntity;
        Assert.notNull((Object)query, (String)"Query must not be 'null'");
        Assert.notNull((Object)((Object)requestMethod), (String)"RequestMethod must not be 'null'");
        QueryParser parser = null;
        parser = query instanceof AbstractQueryDecorator ? this.queryParsers.getForClass(((AbstractQueryDecorator)query).getQueryType()) : this.queryParsers.getForClass(query.getClass());
        SolrQuery solrQuery = parser.constructSolrQuery(query);
        if (clazz != null && (persistedEntity = (SolrPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).hasScoreProperty()) {
            solrQuery.setIncludeScore(true);
        }
        LOGGER.debug("Executing query '{}' against solr.", (Object)solrQuery);
        return this.executeSolrQuery(collectionName, solrQuery, this.getSolrRequestMethod(requestMethod));
    }

    final QueryResponse executeSolrQuery(final SolrQuery solrQuery, final SolrRequest.METHOD method) {
        return this.execute(new SolrCallback<QueryResponse>(){

            @Override
            public QueryResponse doInSolr(SolrClient solrClient) throws SolrServerException, IOException {
                return solrClient.query((SolrParams)solrQuery, method);
            }
        });
    }

    final QueryResponse executeSolrQuery(String collectionName, final SolrQuery solrQuery, final SolrRequest.METHOD method) {
        return this.execute(collectionName, new CollectionCallback<QueryResponse>(){

            @Override
            public QueryResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return solrClient.query(collection, (SolrParams)solrQuery, method);
            }
        });
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    @Override
    public void commit(String collectionName) {
        this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.commit(collection) : solrClient.commit();
            }
        });
    }

    @Override
    public void softCommit() {
        this.softCommit(null);
    }

    @Override
    public void softCommit(String collectionName) {
        this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.commit(collection, true, true, true) : solrClient.commit(true, true, true);
            }
        });
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    @Override
    public void rollback(String collectionName) {
        this.execute(collectionName, new CollectionCallback<UpdateResponse>(){

            @Override
            public UpdateResponse doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return StringUtils.hasText((String)collection) ? solrClient.rollback(collection) : solrClient.rollback();
            }
        });
    }

    @Override
    public SolrInputDocument convertBeanToSolrInputDocument(Object bean) {
        if (bean instanceof SolrInputDocument) {
            return (SolrInputDocument)bean;
        }
        SolrInputDocument document = new SolrInputDocument();
        this.getConverter().write(bean, document);
        return document;
    }

    public String getSchemaName(String collectionName) {
        return this.getSchemaOperations(collectionName).getSchemaName();
    }

    @Override
    public <T> Cursor<T> queryForCursor(Query query, final Class<T> clazz) {
        return new DelegatingCursor<T>(this.queryParsers.getForClass(query.getClass()).constructSolrQuery(query)){

            @Override
            protected DelegatingCursor.PartialResult<T> doLoad(SolrQuery nativeQuery) {
                QueryResponse response = SolrTemplate.this.executeSolrQuery(nativeQuery, SolrTemplate.this.getSolrRequestMethod(SolrTemplate.this.getDefaultRequestMethod()));
                if (response == null) {
                    return new DelegatingCursor.PartialResult("", Collections.emptyList());
                }
                return new DelegatingCursor.PartialResult(response.getNextCursorMark(), SolrTemplate.this.convertQueryResponseToBeans(response, clazz));
            }
        }.open();
    }

    @Override
    public <T> Collection<T> getById(Collection<? extends Serializable> ids, Class<T> clazz) {
        return this.getById(this.getSolrCoreOrBeanCollection(clazz), ids, clazz);
    }

    @Override
    public <T> Collection<T> getById(String collectionName, Collection<? extends Serializable> ids, final Class<T> clazz) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        final ArrayList<String> stringIds = new ArrayList<String>(ids.size());
        for (Serializable serializable : ids) {
            stringIds.add(serializable.toString());
        }
        return (Collection)this.execute(collectionName, new CollectionCallback<Collection<T>>(){

            @Override
            public Collection<T> doInSolr(SolrClient solrClient, String collection) throws SolrServerException, IOException {
                return SolrTemplate.this.convertSolrDocumentListToBeans(solrClient.getById(collection, (Collection)stringIds), clazz);
            }
        });
    }

    @Override
    public <T> T getById(Serializable id, Class<T> clazz) {
        return this.getById(this.getSolrCoreOrBeanCollection(clazz), id, clazz);
    }

    @Override
    public <T> T getById(String collectionName, Serializable id, Class<T> clazz) {
        Assert.notNull((Object)id, (String)"Id must not be 'null'.");
        Collection<T> result = this.getById(collectionName, Collections.singletonList(id), clazz);
        if (result.isEmpty()) {
            return null;
        }
        return result.iterator().next();
    }

    @Override
    public SchemaOperations getSchemaOperations(String collection) {
        return new DefaultSchemaOperations(collection, this);
    }

    private Collection<SolrInputDocument> convertBeansToSolrInputDocuments(Iterable<?> beans) {
        if (beans == null) {
            return Collections.emptyList();
        }
        ArrayList<SolrInputDocument> resultList = new ArrayList<SolrInputDocument>();
        for (Object bean : beans) {
            resultList.add(this.convertBeanToSolrInputDocument(bean));
        }
        return resultList;
    }

    public <T> List<T> convertQueryResponseToBeans(QueryResponse response, Class<T> targetClass) {
        return response != null ? this.convertSolrDocumentListToBeans(response.getResults(), targetClass) : Collections.emptyList();
    }

    public <T> List<T> convertSolrDocumentListToBeans(SolrDocumentList documents, Class<T> targetClass) {
        if (documents == null) {
            return Collections.emptyList();
        }
        return this.getConverter().read(documents, targetClass);
    }

    public <T> T convertSolrDocumentToBean(SolrDocument document, Class<T> targetClass) {
        return (T)this.getConverter().read(targetClass, document);
    }

    protected void assertNoCollection(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Collections are not supported for this operation");
        }
    }

    private final SolrConverter getDefaultSolrConverter() {
        MappingSolrConverter converter = new MappingSolrConverter(this.mappingContext);
        converter.afterPropertiesSet();
        return converter;
    }

    @Override
    public final SolrClient getSolrClient() {
        return this.solrClientFactory.getSolrClient(this.solrCore);
    }

    @Override
    public SolrConverter getConverter() {
        return this.solrConverter;
    }

    public static PersistenceExceptionTranslator getExceptionTranslator() {
        return EXCEPTION_TRANSLATOR;
    }

    private String getSolrCoreOrBeanCollection(Class<?> clazz) {
        return StringUtils.hasText((String)this.solrCore) ? this.solrCore : ((SolrPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).getSolrCoreName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void registerQueryParser(Class<? extends SolrDataQuery> clazz, QueryParser queryParser) {
        this.queryParsers.registerParser(clazz, queryParser);
    }

    public void setSolrConverter(SolrConverter solrConverter) {
        this.solrConverter = solrConverter;
    }

    public String getSolrCore() {
        return this.solrCore;
    }

    public void setSolrCore(String solrCore) {
        this.solrCore = solrCore;
    }

    public void afterPropertiesSet() {
        if (this.mappingContext == null) {
            this.mappingContext = new SimpleSolrMappingContext(new SolrPersistentEntitySchemaCreator(this.solrClientFactory).enable(this.schemaCreationFeatures));
        }
        if (this.solrConverter == null) {
            this.solrConverter = this.getDefaultSolrConverter();
        }
        this.registerPersistenceExceptionTranslator();
    }

    private void registerPersistenceExceptionTranslator() {
        if (this.applicationContext != null && this.applicationContext.getBeansOfType(PersistenceExceptionTranslator.class).isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().registerSingleton("solrExceptionTranslator", (Object)EXCEPTION_TRANSLATOR);
        }
    }

    private SolrRequest.METHOD getSolrRequestMethod(RequestMethod requestMethod) {
        RequestMethod rm = requestMethod != null ? requestMethod : this.getDefaultRequestMethod();
        switch (rm) {
            case GET: {
                return SolrRequest.METHOD.GET;
            }
            case POST: {
                return SolrRequest.METHOD.POST;
            }
            case PUT: {
                return SolrRequest.METHOD.PUT;
            }
        }
        throw new IllegalArgumentException("Unsupported request method type");
    }

    public void setMappingContext(MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public void setSchemaCreationFeatures(Collection<SolrPersistentEntitySchemaCreator.Feature> schemaCreationFeatures) {
        this.schemaCreationFeatures = new HashSet<SolrPersistentEntitySchemaCreator.Feature>(schemaCreationFeatures);
    }

    public Set<SolrPersistentEntitySchemaCreator.Feature> getSchemaCreationFeatures() {
        if (CollectionUtils.isEmpty(this.schemaCreationFeatures)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.schemaCreationFeatures);
    }

    public RequestMethod getDefaultRequestMethod() {
        return this.defaultRequestMethod;
    }
}

