/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class AbstractAmqpInboundAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String[] CONTAINER_VALUE_ATTRIBUTES = new String[]{"acknowledge-mode", "channel-transacted", "concurrent-consumers", "consumers-per-queue", "expose-listener-channel", "phase", "prefetch-count", "queue-names", "recovery-interval", "receive-timeout", "shutdown-timeout", "tx-size", "missing-queues-fatal"};
    private static final String[] CONTAINER_REFERENCE_ATTRIBUTES = new String[]{"advice-chain", "connection-factory", "error-handler", "message-properties-converter", "task-executor", "transaction-attribute", "transaction-manager"};
    private final String adapterClassName;

    AbstractAmqpInboundAdapterParser(String adapterClassName) {
        Assert.hasText((String)adapterClassName, (String)"adapterClassName is required");
        this.adapterClassName = adapterClassName;
    }

    protected final String getBeanClassName(Element element) {
        return this.adapterClassName;
    }

    protected final boolean shouldGenerateId() {
        return false;
    }

    protected final boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String listenerContainerRef = element.getAttribute("listener-container");
        if (StringUtils.hasText((String)listenerContainerRef)) {
            this.assertNoContainerAttributes(element, parserContext);
            builder.addConstructorArgReference(listenerContainerRef);
        } else {
            BeanDefinition listenerContainerBeanDef = this.buildListenerContainer(element, parserContext);
            builder.addConstructorArgValue((Object)listenerContainerBeanDef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        BeanDefinitionBuilder mapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultAmqpHeaderMapper.class);
        mapperBuilder.setFactoryMethod("inboundMapper");
        IntegrationNamespaceUtils.configureHeaderMapper((Element)element, (BeanDefinitionBuilder)builder, (ParserContext)parserContext, (BeanDefinitionBuilder)mapperBuilder, null);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"batch-mode");
        this.configureChannels(element, parserContext, builder);
        AbstractBeanDefinition adapterBeanDefinition = builder.getRawBeanDefinition();
        adapterBeanDefinition.setResource(parserContext.getReaderContext().getResource());
        adapterBeanDefinition.setSource((Object)IntegrationNamespaceUtils.createElementDescription((Element)element));
    }

    private BeanDefinition buildListenerContainer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        String consumersPerQueue;
        if (!element.hasAttribute("queue-names")) {
            parserContext.getReaderContext().error("If no 'listener-container' reference is provided, the 'queue-names' attribute is required.", (Object)element);
        }
        if (StringUtils.hasText((String)(consumersPerQueue = element.getAttribute("consumers-per-queue")))) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(DirectMessageListenerContainer.class);
            if (StringUtils.hasText((String)element.getAttribute("concurrent-consumers"))) {
                parserContext.getReaderContext().error("'consumers-per-queue' and 'concurrent-consumers' are mutually exclusive", (Object)element);
            }
            if (StringUtils.hasText((String)element.getAttribute("tx-size"))) {
                parserContext.getReaderContext().error("'tx-size' is not allowed with 'consumers-per-queue'", (Object)element);
            }
            if (StringUtils.hasText((String)element.getAttribute("receive-timeout"))) {
                parserContext.getReaderContext().error("'receive-timeout' is not allowed with 'consumers-per-queue'", (Object)element);
            }
            builder.addPropertyValue("consumersPerQueue", (Object)consumersPerQueue);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMessageListenerContainer.class);
        }
        String connectionFactoryRef = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactoryRef)) {
            connectionFactoryRef = "rabbitConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactoryRef);
        for (String attributeName : CONTAINER_VALUE_ATTRIBUTES) {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)attributeName);
        }
        for (String attributeName : CONTAINER_REFERENCE_ATTRIBUTES) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)attributeName);
        }
        return builder.getBeanDefinition();
    }

    private void assertNoContainerAttributes(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        ArrayList<String> allContainerAttributes = new ArrayList<String>(Arrays.asList(CONTAINER_VALUE_ATTRIBUTES));
        allContainerAttributes.addAll(Arrays.asList(CONTAINER_REFERENCE_ATTRIBUTES));
        for (String attributeName : allContainerAttributes) {
            if (!StringUtils.hasText((String)element.getAttribute(attributeName))) continue;
            parserContext.getReaderContext().error("Attribute '" + attributeName + "' is not allowed when a 'listener-container' reference has been provided", source);
        }
    }

    protected abstract void configureChannels(Element var1, ParserContext var2, BeanDefinitionBuilder var3);
}

