/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.core.AbstractBeanMethodProcessor;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.config.java.valuesource.ValueSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalValueMethodProcessor
extends AbstractBeanMethodProcessor {
    private final ValueSource valueSource;

    public ExternalValueMethodProcessor(ValueSource valueSource) {
        super(ExternalValue.class);
        this.valueSource = valueSource;
    }

    private ExternalValueMethodProcessor() {
        super(ExternalValue.class);
        this.valueSource = null;
    }

    @Override
    public Object processMethod(Method m) throws ValueResolutionException {
        ExternalValue ev = m.getAnnotation(ExternalValue.class);
        Assert.notNull((Object)ev, (String)"method must be annotated with @ExternalValue");
        String name = ev.value();
        if ("".equals(name) && (name = m.getName()).startsWith("get")) {
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return this.valueSource.resolve(name, m.getReturnType());
    }

    public static boolean isExternalValueCreationMethod(Method candidateMethod) {
        return new ExternalValueMethodProcessor().understands(candidateMethod);
    }

    public static Collection<Method> findExternalValueCreationMethods(Class<?> configurationClass) {
        return new ExternalValueMethodProcessor().findMatchingMethods(configurationClass);
    }
}

