/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.userdetails;

import java.util.ArrayList;
import java.util.List;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public final class GrantedAuthorityFromAssertionAttributesUserDetailsService
extends AbstractCasAssertionUserDetailsService {
    private static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";
    private final String[] attributes;
    private boolean convertToUpperCase = true;

    public GrantedAuthorityFromAssertionAttributesUserDetailsService(String[] attributes) {
        Assert.notNull((Object)attributes, (String)"attributes cannot be null.");
        Assert.isTrue((attributes.length > 0 ? 1 : 0) != 0, (String)"At least one attribute is required to retrieve roles from.");
        this.attributes = attributes;
    }

    protected UserDetails loadUserDetails(Assertion assertion) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String attribute : this.attributes) {
            Object value = assertion.getPrincipal().getAttributes().get(attribute);
            if (value == null) continue;
            if (value instanceof List) {
                List list = (List)value;
                for (Object o : list) {
                    grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? o.toString().toUpperCase() : o.toString()));
                }
                continue;
            }
            grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? value.toString().toUpperCase() : value.toString()));
        }
        return new User(assertion.getPrincipal().getName(), NON_EXISTENT_PASSWORD_VALUE, true, true, true, true, grantedAuthorities);
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }
}

