/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.lang.Nullable;

public class PathMatchConfigurer {
    @Nullable
    private Boolean trailingSlashMatch;
    @Nullable
    private Boolean caseSensitiveMatch;
    @Nullable
    private Map<String, Predicate<Class<?>>> pathPrefixes;

    public PathMatchConfigurer setUseCaseSensitiveMatch(Boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
        return this;
    }

    @Deprecated(since="6.0")
    public PathMatchConfigurer setUseTrailingSlashMatch(Boolean trailingSlashMatch) {
        this.trailingSlashMatch = trailingSlashMatch;
        return this;
    }

    public PathMatchConfigurer addPathPrefix(String prefix, Predicate<Class<?>> predicate) {
        if (this.pathPrefixes == null) {
            this.pathPrefixes = new LinkedHashMap();
        }
        this.pathPrefixes.put(prefix, predicate);
        return this;
    }

    @Nullable
    @Deprecated
    protected Boolean isUseTrailingSlashMatch() {
        return this.trailingSlashMatch;
    }

    @Nullable
    protected Boolean isUseCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    @Nullable
    protected Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }
}

