/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractWebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketSession
extends AbstractWebSocketSession<Session> {
    private final Flux<WebSocketMessage> flux;
    private final Sinks.One<CloseStatus> closeStatusSink = Sinks.one();
    private final Lock lock = new ReentrantLock();
    private long requested = 0L;
    private boolean awaitingMessage = false;
    @Nullable
    private FluxSink<WebSocketMessage> sink;
    @Nullable
    private final Sinks.Empty<Void> handlerCompletionSink;

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, null);
    }

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(session, ObjectUtils.getIdentityHexString((Object)session), info, factory);
        this.handlerCompletionSink = completionSink;
        this.flux = Flux.create(emitter -> {
            this.sink = emitter;
            emitter.onRequest(n -> {
                boolean demand = false;
                this.lock.lock();
                try {
                    this.requested = Math.addExact(this.requested, n);
                    if (this.requested < 0L) {
                        this.requested = Long.MAX_VALUE;
                    }
                    if (!this.awaitingMessage && this.requested > 0L) {
                        if (this.requested != Long.MAX_VALUE) {
                            --this.requested;
                        }
                        this.awaitingMessage = true;
                        demand = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (demand) {
                    ((Session)this.getDelegate()).demand();
                }
            });
        });
    }

    void handleMessage(WebSocketMessage message) {
        Assert.state((this.sink != null ? 1 : 0) != 0, (String)"No sink available");
        this.sink.next((Object)message);
        boolean demand = false;
        this.lock.lock();
        try {
            if (!this.awaitingMessage) {
                throw new IllegalStateException();
            }
            this.awaitingMessage = false;
            if (this.requested > 0L) {
                if (this.requested != Long.MAX_VALUE) {
                    --this.requested;
                }
                this.awaitingMessage = true;
                demand = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (demand) {
            ((Session)this.getDelegate()).demand();
        }
    }

    void handleError(Throwable ex) {
    }

    void handleClose(CloseStatus closeStatus) {
        this.closeStatusSink.tryEmitValue((Object)closeStatus);
        if (this.sink != null) {
            this.sink.complete();
        }
    }

    void onHandlerError(Throwable error) {
        if (this.handlerCompletionSink != null) {
            this.handlerCompletionSink.tryEmitError(error);
        }
        ((Session)this.getDelegate()).close(1011, error.getMessage(), Callback.NOOP);
    }

    void onHandleComplete() {
        if (this.handlerCompletionSink != null) {
            this.handlerCompletionSink.tryEmitEmpty();
        }
        ((Session)this.getDelegate()).close(1000, null, Callback.NOOP);
    }

    @Override
    public boolean isOpen() {
        return ((Session)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        Callback.Completable callback = new Callback.Completable();
        ((Session)this.getDelegate()).close(status.getCode(), status.getReason(), (Callback)callback);
        return Mono.fromFuture((CompletableFuture)callback);
    }

    @Override
    public Mono<CloseStatus> closeStatus() {
        return this.closeStatusSink.asMono();
    }

    @Override
    public Flux<WebSocketMessage> receive() {
        return this.flux;
    }

    @Override
    public Mono<Void> send(Publisher<WebSocketMessage> messages) {
        return Flux.from(messages).flatMap(this::sendMessage, 1).then();
    }

    protected Mono<Void> sendMessage(WebSocketMessage message) {
        final Callback.Completable completable = new Callback.Completable();
        DataBuffer dataBuffer = message.getPayload();
        final Session session = (Session)this.getDelegate();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            String text = dataBuffer.toString(StandardCharsets.UTF_8);
            session.sendText(text, (Callback)completable);
        } else {
            switch (message.getType()) {
                case BINARY: {
                    final DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();
                    new IteratingCallback(){

                        protected IteratingCallback.Action process() {
                            if (!iterator.hasNext()) {
                                return IteratingCallback.Action.SUCCEEDED;
                            }
                            ByteBuffer buffer = (ByteBuffer)iterator.next();
                            boolean last = iterator.hasNext();
                            session.sendPartialBinary(buffer, last, Callback.from(() -> (this).succeeded(), arg_0 -> (this).failed(arg_0)));
                            return IteratingCallback.Action.SCHEDULED;
                        }

                        protected void onCompleteSuccess() {
                            iterator.close();
                            completable.succeed();
                        }

                        protected void onCompleteFailure(Throwable cause) {
                            iterator.close();
                            completable.fail(cause);
                        }
                    }.iterate();
                    break;
                }
                case PING: {
                    ByteBuffer buffer = BufferUtil.allocate((int)125);
                    dataBuffer.toByteBuffer(buffer);
                    session.sendPing(buffer, (Callback)completable);
                    break;
                }
                case PONG: {
                    ByteBuffer buffer = BufferUtil.allocate((int)125);
                    dataBuffer.toByteBuffer(buffer);
                    session.sendPong(buffer, (Callback)completable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected message type: " + String.valueOf((Object)message.getType()));
                }
            }
        }
        return Mono.fromFuture((CompletableFuture)completable);
    }
}

