/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;

public abstract class AdvisorChainFactoryUtils {
    public static final AdvisorChainFactory SIMPLE_ADVISOR_CHAIN_FACTORY = new AdvisorChainFactory(){

        public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
            return AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
        }

        public void activated(AdvisedSupport advisedSupport) {
        }

        public void adviceChanged(AdvisedSupport advisedSupport) {
        }
    };

    public static List calculateInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        ArrayList<Object> interceptorList = new ArrayList<Object>(config.getAdvisors().length);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        for (int i = 0; i < config.getAdvisors().length; ++i) {
            IntroductionAdvisor ia;
            Interceptor[] interceptors;
            Advisor advisor = config.getAdvisors()[i];
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!pointcutAdvisor.getPointcut().getClassFilter().matches(targetClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (!mm.matches(method, targetClass)) continue;
                if (mm.isRuntime()) {
                    for (int j = 0; j < interceptors.length; ++j) {
                        interceptorList.add(new InterceptorAndDynamicMethodMatcher((MethodInterceptor)interceptors[j], mm));
                    }
                    continue;
                }
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) continue;
            interceptors = registry.getInterceptors(advisor);
            interceptorList.addAll(Arrays.asList(interceptors));
        }
        return interceptorList;
    }
}

