/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.aop.support.AbstractRegexpMethodPointcut;

public class Perl5RegexpMethodPointcut
extends AbstractRegexpMethodPointcut {
    private transient Pattern[] compiledPatterns = new Pattern[0];
    private transient PatternMatcher matcher;

    protected void initPatternRepresentation(String[] patterns) throws IllegalArgumentException {
        this.compiledPatterns = new Pattern[patterns.length];
        Perl5Compiler compiler = new Perl5Compiler();
        for (int i = 0; i < patterns.length; ++i) {
            try {
                this.compiledPatterns[i] = compiler.compile(patterns[i], 32768);
                continue;
            }
            catch (MalformedPatternException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        this.matcher = new Perl5Matcher();
    }

    protected boolean matches(String pattern, int patternIndex) {
        boolean matched = this.matcher.matches(pattern, this.compiledPatterns[patternIndex]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Candidate is [" + pattern + "]; pattern is [" + this.compiledPatterns[patternIndex].getPattern() + "]; matched=" + matched));
        }
        return matched;
    }
}

