/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.SqlCall;

public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource ds, String name) {
        this.setDataSource(ds);
        this.setSql(name);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String name) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(name);
    }

    public void declareParameter(SqlParameter param) throws InvalidDataAccessApiUsageException {
        if (param.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(param);
    }

    public Map execute(Map inParams) throws DataAccessException {
        this.validateParameters(inParams.values().toArray());
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParams), this.getDeclaredParameters());
    }

    public Map execute(ParameterMapper inParamMapper) throws DataAccessException {
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParamMapper), this.getDeclaredParameters());
    }
}

