/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.rmi.RmiBasedExporter;

public class RmiServiceExporter
extends RmiBasedExporter
implements InitializingBean,
DisposableBean {
    private String serviceName;
    private int servicePort = 0;
    private RMIClientSocketFactory clientSocketFactory;
    private RMIServerSocketFactory serverSocketFactory;
    private Registry registry;
    private String registryHost;
    private int registryPort = 1099;
    private RMIClientSocketFactory registryClientSocketFactory;
    private RMIServerSocketFactory registryServerSocketFactory;
    private Remote exportedObject;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public void setClientSocketFactory(RMIClientSocketFactory clientSocketFactory) {
        this.clientSocketFactory = clientSocketFactory;
    }

    public void setServerSocketFactory(RMIServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void setRegistryClientSocketFactory(RMIClientSocketFactory registryClientSocketFactory) {
        this.registryClientSocketFactory = registryClientSocketFactory;
    }

    public void setRegistryServerSocketFactory(RMIServerSocketFactory registryServerSocketFactory) {
        this.registryServerSocketFactory = registryServerSocketFactory;
    }

    public void afterPropertiesSet() throws RemoteException {
        this.checkService();
        if (this.serviceName == null) {
            throw new IllegalArgumentException("serviceName is required");
        }
        if (this.clientSocketFactory instanceof RMIServerSocketFactory) {
            this.serverSocketFactory = (RMIServerSocketFactory)((Object)this.clientSocketFactory);
        }
        if (this.clientSocketFactory != null && this.serverSocketFactory == null || this.clientSocketFactory == null && this.serverSocketFactory != null) {
            throw new IllegalArgumentException("Both RMIClientSocketFactory and RMIServerSocketFactory or none required");
        }
        if (this.registryClientSocketFactory instanceof RMIServerSocketFactory) {
            this.registryServerSocketFactory = (RMIServerSocketFactory)((Object)this.registryClientSocketFactory);
        }
        if (this.registryClientSocketFactory == null && this.registryServerSocketFactory != null) {
            throw new IllegalArgumentException("RMIServerSocketFactory without RMIClientSocketFactory for registry not supported");
        }
        if (this.registry == null) {
            this.registry = this.getRegistry(this.registryHost, this.registryPort, this.registryClientSocketFactory, this.registryServerSocketFactory);
        }
        this.exportedObject = this.getObjectToExport();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Binding RMI service '" + this.serviceName + "' to registry at port '" + this.registryPort + "'"));
        }
        if (this.clientSocketFactory != null) {
            UnicastRemoteObject.exportObject(this.exportedObject, this.servicePort, this.clientSocketFactory, this.serverSocketFactory);
        } else {
            UnicastRemoteObject.exportObject(this.exportedObject, this.servicePort);
        }
        this.registry.rebind(this.serviceName, this.exportedObject);
    }

    protected Registry getRegistry(String registryHost, int registryPort, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        if (registryHost != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Looking for RMI registry at port '" + registryPort + "' of host [" + registryHost + "]"));
            }
            Registry reg = LocateRegistry.getRegistry(registryHost, registryPort, clientSocketFactory);
            this.testRegistry(reg);
            return reg;
        }
        return this.getRegistry(registryPort, clientSocketFactory, serverSocketFactory);
    }

    protected Registry getRegistry(int registryPort, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        if (clientSocketFactory != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Looking for RMI registry at port '" + registryPort + "', using custom socket factory"));
            }
            try {
                Registry reg = LocateRegistry.getRegistry(null, registryPort, clientSocketFactory);
                this.testRegistry(reg);
                return reg;
            }
            catch (RemoteException ex) {
                this.logger.debug((Object)"RMI registry access threw exception", (Throwable)ex);
                this.logger.warn((Object)"Could not detect RMI registry - creating new one");
                return LocateRegistry.createRegistry(registryPort, clientSocketFactory, serverSocketFactory);
            }
        }
        return this.getRegistry(registryPort);
    }

    protected Registry getRegistry(int registryPort) throws RemoteException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Looking for RMI registry at port '" + registryPort + "'"));
        }
        try {
            Registry reg = LocateRegistry.getRegistry(registryPort);
            this.testRegistry(reg);
            return reg;
        }
        catch (RemoteException ex) {
            this.logger.debug((Object)"RMI registry access threw exception", (Throwable)ex);
            this.logger.warn((Object)"Could not detect RMI registry - creating new one");
            return LocateRegistry.createRegistry(registryPort);
        }
    }

    protected void testRegistry(Registry registry) throws RemoteException {
        registry.list();
    }

    public void destroy() throws RemoteException, NotBoundException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Unbinding RMI service '" + this.serviceName + "' from registry at port '" + this.registryPort + "'"));
        }
        this.registry.unbind(this.serviceName);
        UnicastRemoteObject.unexportObject(this.exportedObject, true);
    }
}

