/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class WebApplicationContextVariableResolver
extends VariableResolver {
    public static final String WEB_APPLICATION_CONTEXT_VARIABLE_NAME = "webApplicationContext";
    protected final VariableResolver originalVariableResolver;

    public WebApplicationContextVariableResolver(VariableResolver originalVariableResolver) {
        this.originalVariableResolver = originalVariableResolver;
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        Object value = null;
        if (WEB_APPLICATION_CONTEXT_VARIABLE_NAME.equals(name)) {
            value = this.getWebApplicationContext(context);
        }
        if (value == null) {
            value = this.originalVariableResolver.resolveVariable(context, name);
        }
        return value;
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getWebApplicationContext(facesContext);
    }
}

