/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".HANDLER";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".CONTEXT";
    public static final String MULTIPART_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".MULTIPART";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".LOCALE";
    public static final String THEME_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherServlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private static final Properties defaultStrategies = new Properties();
    private boolean cleanupAfterInclude = true;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private List viewResolvers;
    static /* synthetic */ Class class$org$springframework$web$servlet$DispatcherServlet;
    static /* synthetic */ Class class$org$springframework$web$servlet$LocaleResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ThemeResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerExceptionResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ViewResolver;

    public void setCleanupAfterInclude(boolean cleanupAfterInclude) {
        this.cleanupAfterInclude = cleanupAfterInclude;
    }

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.initMultipartResolver();
        this.initLocaleResolver();
        this.initThemeResolver();
        this.initHandlerMappings();
        this.initHandlerAdapters();
        this.initHandlerExceptionResolvers();
        this.initViewResolvers();
    }

    private void initMultipartResolver() throws BeansException {
        block3: {
            try {
                this.multipartResolver = (MultipartResolver)this.getWebApplicationContext().getBean(MULTIPART_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initLocaleResolver() throws BeansException {
        block3: {
            try {
                this.localeResolver = (LocaleResolver)this.getWebApplicationContext().getBean(LOCALE_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.localeResolver = (LocaleResolver)this.getDefaultStrategy(class$org$springframework$web$servlet$LocaleResolver == null ? (class$org$springframework$web$servlet$LocaleResolver = DispatcherServlet.class$("org.springframework.web.servlet.LocaleResolver")) : class$org$springframework$web$servlet$LocaleResolver);
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
            }
        }
    }

    private void initThemeResolver() throws BeansException {
        block3: {
            try {
                this.themeResolver = (ThemeResolver)this.getWebApplicationContext().getBean(THEME_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.themeResolver = (ThemeResolver)this.getDefaultStrategy(class$org$springframework$web$servlet$ThemeResolver == null ? (class$org$springframework$web$servlet$ThemeResolver = DispatcherServlet.class$("org.springframework.web.servlet.ThemeResolver")) : class$org$springframework$web$servlet$ThemeResolver);
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
            }
        }
    }

    private void initHandlerMappings() throws BeansException {
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getWebApplicationContext(), class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping, true, false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                Object hm = this.getWebApplicationContext().getBean(HANDLER_MAPPING_BEAN_NAME);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters() throws BeansException {
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getWebApplicationContext(), class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter, true, false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerAdapters, new OrderComparator());
            }
        } else {
            try {
                Object ha = this.getWebApplicationContext().getBean(HANDLER_ADAPTER_BEAN_NAME);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers() throws BeansException {
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getWebApplicationContext(), class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver, true, false);
            this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
        } else {
            try {
                Object her = this.getWebApplicationContext().getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.handlerExceptionResolvers = this.getDefaultStrategies(class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver);
            }
        }
    }

    private void initViewResolvers() throws BeansException {
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getWebApplicationContext(), class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver, true, false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                Object vr = this.getWebApplicationContext().getBean(VIEW_RESOLVER_BEAN_NAME);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    protected Object getDefaultStrategy(Class strategyInterface) throws BeansException {
        List strategies = this.getDefaultStrategies(strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherServlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected List getDefaultStrategies(Class strategyInterface) throws BeansException {
        String key = strategyInterface.getName();
        try {
            ArrayList<Object> strategies = null;
            String value = defaultStrategies.getProperty(key);
            if (value != null) {
                String[] classNames = StringUtils.commaDelimitedListToStringArray(value);
                strategies = new ArrayList<Object>(classNames.length);
                for (int i = 0; i < classNames.length; ++i) {
                    Class<?> clazz = Class.forName(classNames[i], true, ((Object)((Object)this)).getClass().getClassLoader());
                    Object strategy = BeanUtils.instantiateClass(clazz);
                    if (strategy instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)strategy).setApplicationContext(this.getWebApplicationContext());
                    }
                    strategies.add(strategy);
                }
            } else {
                strategies = Collections.EMPTY_LIST;
            }
            return strategies;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class for interface [" + key + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "' received request for [" + request.getRequestURI() + "]"));
        }
        HashMap<String, Object> attributesSnapshot = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            this.logger.debug((Object)"Taking snapshot of request attributes before include");
            attributesSnapshot = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (!this.cleanupAfterInclude && !attrName.startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
                attributesSnapshot.put(attrName, request.getAttribute(attrName));
            }
        }
        request.setAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
        request.setAttribute(LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
        request.setAttribute(THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
        try {
            this.doDispatch(request, response);
        }
        finally {
            if (attributesSnapshot != null) {
                this.restoreAttributesAfterInclude(request, attributesSnapshot);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            HandlerExecutionChain mappedHandler = this.getHandler(request, true);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Last-Modified value for [" + request.getRequestURI() + "] is [" + lastModified + "]"));
            }
            return lastModified;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)ex);
            return -1L;
        }
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartHttpServletRequest) {
                this.logger.info((Object)"Request is already a MultipartHttpServletRequest - if not in a forward, this typically results from an additional MultipartFilter in web.xml");
            } else {
                request.setAttribute(MULTIPART_RESOLVER_ATTRIBUTE, (Object)this.multipartResolver);
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request, boolean cache) throws Exception {
        HandlerExecutionChain handler = (HandlerExecutionChain)request.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handler != null) {
            if (!cache) {
                request.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handler;
        }
        Iterator it = this.handlerMappings.iterator();
        while (it.hasNext()) {
            HandlerMapping hm = (HandlerMapping)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            if (cache) {
                request.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handler);
            }
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No mapping for [" + request.getRequestURI() + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        response.sendError(404);
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Iterator it = this.handlerAdapters.iterator();
        while (it.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = (HandlerExceptionResolver)it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = this.localeResolver.resolveLocale(request);
        response.setLocale(locale);
        View view = null;
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), locale, request);
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mv.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = mv.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in servlet with name '" + this.getServletName() + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        view.render(mv.getModelInternal(), request, response);
    }

    protected View resolveViewName(String viewName, Map model, Locale locale, HttpServletRequest request) throws Exception {
        Iterator it = this.viewResolvers.iterator();
        while (it.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)it.next();
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void triggerAfterCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        if (mappedHandler != null && mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    private void restoreAttributesAfterInclude(HttpServletRequest request, Map attributesSnapshot) {
        this.logger.debug((Object)"Restoring snapshot of request attributes after include");
        HashSet<String> attrsToCheck = new HashSet<String>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            if (!this.cleanupAfterInclude && !attrName.startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
            attrsToCheck.add(attrName);
        }
        Iterator it = attrsToCheck.iterator();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            Object attrValue = attributesSnapshot.get(attrName);
            if (attrValue != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring original value of attribute [" + attrName + "] after include"));
                }
                request.setAttribute(attrName, attrValue);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing attribute [" + attrName + "] after include"));
            }
            request.removeAttribute(attrName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet);
            InputStream is = resource.getInputStream();
            try {
                defaultStrategies.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherServlet.properties': " + ex.getMessage());
        }
    }
}

