/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieLocaleResolver
extends CookieGenerator
implements LocaleResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    static /* synthetic */ Class class$org$springframework$web$servlet$i18n$CookieLocaleResolver;

    public CookieLocaleResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null) {
            return locale;
        }
        Cookie cookie = WebUtils.getCookie(request, this.getCookieName());
        if (cookie != null) {
            locale = StringUtils.parseLocaleString(cookie.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'"));
            }
            if (locale != null) {
                request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
                return locale;
            }
        }
        return request.getLocale();
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (locale != null) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
            this.addCookie(response, locale.toString());
        } else {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)request.getLocale());
            this.removeCookie(response);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

