/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.jpa;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.springframework.statemachine.data.RepositoryAction;
import org.springframework.statemachine.data.RepositoryState;
import org.springframework.statemachine.data.jpa.JpaRepositoryAction;
import org.springframework.statemachine.state.PseudoStateKind;

@Entity
@Table(name="State")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class JpaRepositoryState
extends RepositoryState {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String machineId;
    private String state;
    private String region;
    @Column(name="initialState")
    private boolean initial;
    private PseudoStateKind kind;
    private String submachineId;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_state_initial_action"))
    private JpaRepositoryAction initialAction;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_state_parent_state"))
    private JpaRepositoryState parentState;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(foreignKey=@ForeignKey(name="fk_state_state_actions_s"), inverseForeignKey=@ForeignKey(name="fk_state_state_actions_a"))
    private Set<JpaRepositoryAction> stateActions;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(foreignKey=@ForeignKey(name="fk_state_entry_actions_s"), inverseForeignKey=@ForeignKey(name="fk_state_entry_actions_a"))
    private Set<JpaRepositoryAction> entryActions;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(foreignKey=@ForeignKey(name="fk_state_exit_actions_s"), inverseForeignKey=@ForeignKey(name="fk_state_exit_actions_a"))
    private Set<JpaRepositoryAction> exitActions;
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @CollectionTable(name="DeferredEvents", foreignKey=@ForeignKey(name="fk_state_deferred_events"))
    private Set<String> deferredEvents;

    public JpaRepositoryState() {
        this(null);
    }

    public JpaRepositoryState(String state) {
        this(state, false);
    }

    public JpaRepositoryState(String state, boolean initial) {
        this(null, state, initial);
    }

    public JpaRepositoryState(String machineId, String state, boolean initial) {
        this(machineId, null, state, initial);
    }

    public JpaRepositoryState(String machineId, JpaRepositoryState parentState, String state, boolean initial) {
        this(machineId, parentState, state, initial, null, null, null);
    }

    public JpaRepositoryState(String machineId, JpaRepositoryState parentState, String state, boolean initial, Set<JpaRepositoryAction> stateActions, Set<JpaRepositoryAction> entryActions, Set<JpaRepositoryAction> exitActions) {
        this.machineId = machineId == null ? "" : machineId;
        this.parentState = parentState;
        this.state = state;
        this.initial = initial;
        this.stateActions = stateActions;
        this.entryActions = entryActions;
        this.exitActions = exitActions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public JpaRepositoryState getParentState() {
        return this.parentState;
    }

    public void setParentState(JpaRepositoryState parentState) {
        this.parentState = parentState;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public PseudoStateKind getKind() {
        return this.kind;
    }

    public void setKind(PseudoStateKind kind) {
        this.kind = kind;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public RepositoryAction getInitialAction() {
        return this.initialAction;
    }

    public void setInitialAction(JpaRepositoryAction initialAction) {
        this.initialAction = initialAction;
    }

    public Set<JpaRepositoryAction> getStateActions() {
        return this.stateActions;
    }

    public void setStateActions(Set<JpaRepositoryAction> stateActions) {
        this.stateActions = stateActions;
    }

    public Set<JpaRepositoryAction> getEntryActions() {
        return this.entryActions;
    }

    public void setEntryActions(Set<JpaRepositoryAction> entryActions) {
        this.entryActions = entryActions;
    }

    public Set<JpaRepositoryAction> getExitActions() {
        return this.exitActions;
    }

    public void setExitActions(Set<JpaRepositoryAction> exitActions) {
        this.exitActions = exitActions;
    }

    public Set<String> getDeferredEvents() {
        return this.deferredEvents;
    }

    public void setDeferredEvents(Set<String> deferredEvents) {
        this.deferredEvents = deferredEvents;
    }

    public String getSubmachineId() {
        return this.submachineId;
    }

    public void setSubmachineId(String submachineId) {
        this.submachineId = submachineId;
    }

    public String toString() {
        return "JpaRepositoryState [id=" + this.id + ", machineId=" + this.machineId + ", state=" + this.state + ", region=" + this.region + ", initial=" + this.initial + ", kind=" + this.kind + ", submachineId=" + this.submachineId + ", parentState=" + (Object)((Object)this.parentState) + ", stateActions=" + this.stateActions + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", deferredEvents=" + this.deferredEvents + "]";
    }
}

