/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.recipes.persist;

import java.util.Iterator;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineFunction;
import org.springframework.statemachine.listener.AbstractCompositeListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.transition.Transition;
import org.springframework.util.Assert;

public class PersistStateMachineHandler
extends LifecycleObjectSupport {
    private final StateMachine<String, String> stateMachine;
    private final PersistingStateChangeInterceptor interceptor = new PersistingStateChangeInterceptor();
    private final CompositePersistStateChangeListener listeners = new CompositePersistStateChangeListener();

    public PersistStateMachineHandler(StateMachine<String, String> stateMachine) {
        Assert.notNull(stateMachine, (String)"State machine must be set");
        this.stateMachine = stateMachine;
    }

    protected void onInit() throws Exception {
        this.stateMachine.getStateMachineAccessor().doWithAllRegions((StateMachineFunction)new StateMachineFunction<StateMachineAccess<String, String>>(){

            public void apply(StateMachineAccess<String, String> function) {
                function.addStateMachineInterceptor((StateMachineInterceptor)PersistStateMachineHandler.this.interceptor);
            }
        });
    }

    public boolean handleEventWithState(Message<String> event, String state) {
        this.stateMachine.stop();
        List withAllRegions = this.stateMachine.getStateMachineAccessor().withAllRegions();
        for (StateMachineAccess a : withAllRegions) {
            a.resetStateMachine((StateMachineContext)new DefaultStateMachineContext((Object)state, null, null, null));
        }
        this.stateMachine.start();
        return this.stateMachine.sendEvent(event);
    }

    public void addPersistStateChangeListener(PersistStateChangeListener listener) {
        this.listeners.register(listener);
    }

    private class CompositePersistStateChangeListener
    extends AbstractCompositeListener<PersistStateChangeListener>
    implements PersistStateChangeListener {
        private CompositePersistStateChangeListener() {
        }

        @Override
        public void onPersist(State<String, String> state, Message<String> message, Transition<String, String> transition, StateMachine<String, String> stateMachine) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                PersistStateChangeListener listener = (PersistStateChangeListener)iterator.next();
                listener.onPersist(state, message, transition, stateMachine);
            }
        }
    }

    private class PersistingStateChangeInterceptor
    extends StateMachineInterceptorAdapter<String, String> {
        private PersistingStateChangeInterceptor() {
        }

        public void preStateChange(State<String, String> state, Message<String> message, Transition<String, String> transition, StateMachine<String, String> stateMachine, StateMachine<String, String> rootStateMachine) {
            PersistStateMachineHandler.this.listeners.onPersist(state, message, transition, stateMachine);
        }
    }

    public static interface PersistStateChangeListener {
        public void onPersist(State<String, String> var1, Message<String> var2, Transition<String, String> var3, StateMachine<String, String> var4);
    }
}

