/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.ConnectionPointReference;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.SpelExpressionAction;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.EntryData;
import org.springframework.statemachine.config.model.ExitData;
import org.springframework.statemachine.config.model.HistoryData;
import org.springframework.statemachine.config.model.JunctionData;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.guard.SpelExpressionGuard;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.uml.support.UmlUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UmlModelParser {
    public static final String LANGUAGE_BEAN = "bean";
    public static final String LANGUAGE_SPEL = "spel";
    private final Model model;
    private final StateMachineComponentResolver<String, String> resolver;
    private final Collection<StateData<String, String>> stateDatas = new ArrayList<StateData<String, String>>();
    private final Collection<TransitionData<String, String>> transitionDatas = new ArrayList<TransitionData<String, String>>();
    private final Collection<EntryData<String, String>> entrys = new ArrayList<EntryData<String, String>>();
    private final Collection<ExitData<String, String>> exits = new ArrayList<ExitData<String, String>>();
    private final Collection<HistoryData<String, String>> historys = new ArrayList<HistoryData<String, String>>();
    private final Map<String, LinkedList<ChoiceData<String, String>>> choices = new HashMap<String, LinkedList<ChoiceData<String, String>>>();
    private final Map<String, LinkedList<JunctionData<String, String>>> junctions = new HashMap<String, LinkedList<JunctionData<String, String>>>();
    private final Map<String, List<String>> forks = new HashMap<String, List<String>>();
    private final Map<String, List<String>> joins = new HashMap<String, List<String>>();
    private final AtomicInteger pseudostateNamingCounter = new AtomicInteger(1);
    private final Map<NamedElement, String> pseudostateNaming = new HashMap<NamedElement, String>();

    public UmlModelParser(Model model, StateMachineComponentResolver<String, String> resolver) {
        Assert.notNull((Object)model, (String)"Model must be set");
        Assert.notNull(resolver, (String)"Resolver must be set");
        this.model = model;
        this.resolver = resolver;
    }

    public DataHolder parseModel() {
        EList packagedElements = this.model.getPackagedElements();
        StateMachine stateMachine = null;
        Collection stateMachines = EcoreUtil.getObjectsByType((Collection)packagedElements, (EClassifier)UMLPackage.Literals.STATE_MACHINE);
        for (StateMachine machine : stateMachines) {
            EList submachineRefs = machine.getSubmachineStates();
            if (submachineRefs.size() == 0) {
                stateMachine = machine;
            }
            this.handleStateMachine(machine);
        }
        if (stateMachine == null) {
            throw new IllegalArgumentException("Can't find root statemachine from model");
        }
        HashMap<String, LinkedList<ChoiceData<String, String>>> choicesCopy = new HashMap<String, LinkedList<ChoiceData<String, String>>>();
        choicesCopy.putAll(this.choices);
        HashMap<String, LinkedList<JunctionData<String, String>>> junctionsCopy = new HashMap<String, LinkedList<JunctionData<String, String>>>();
        junctionsCopy.putAll(this.junctions);
        return new DataHolder((StatesData<String, String>)new StatesData(this.stateDatas), (TransitionsData<String, String>)new TransitionsData(this.transitionDatas, choicesCopy, junctionsCopy, this.forks, this.joins, this.entrys, this.exits, this.historys));
    }

    private void handleStateMachine(StateMachine stateMachine) {
        for (Region region : stateMachine.getRegions()) {
            this.handleRegion(region);
        }
    }

    private String resolveName(NamedElement pseudostate) {
        return this.pseudostateNaming.computeIfAbsent(pseudostate, key -> {
            String name = pseudostate.getName();
            if (ObjectUtils.isEmpty((Object)name) && key instanceof Pseudostate) {
                name = ((Pseudostate)key).getKind().getName() + this.pseudostateNamingCounter.getAndIncrement();
            }
            return name;
        });
    }

    private void handleRegion(Region region) {
        for (Vertex vertex : region.getSubvertices()) {
            String regionId;
            String parent;
            State state;
            if (vertex instanceof State) {
                EList submachineStates;
                state = (State)vertex;
                parent = null;
                regionId = null;
                if (state.getContainer().getOwner() instanceof State) {
                    parent = ((State)state.getContainer().getOwner()).getName();
                }
                if (parent == null && region.getOwner() instanceof StateMachine && (submachineStates = ((StateMachine)region.getOwner()).getSubmachineStates()).size() == 1) {
                    parent = ((State)submachineStates.get(0)).getName();
                }
                if (state.getOwner() instanceof Region) {
                    regionId = ((Region)state.getOwner()).getName();
                }
                boolean isInitialState = UmlUtils.isInitialState(state);
                StateData<String, String> stateData = this.handleActions((StateData<String, String>)new StateData((Object)parent, (Object)regionId, (Object)state.getName(), isInitialState), state);
                if (isInitialState) {
                    stateData.setInitialAction(this.resolveInitialTransitionAction(state));
                }
                stateData.setDeferred(UmlUtils.resolveDererredEvents(state));
                if (UmlUtils.isFinalState(state)) {
                    stateData.setEnd(true);
                }
                this.stateDatas.add(stateData);
                for (ConnectionPointReference cpr : state.getConnections()) {
                    StateData cpStateData;
                    if (cpr.getEntries() != null) {
                        for (Pseudostate cp : cpr.getEntries()) {
                            cpStateData = new StateData((Object)parent, (Object)regionId, (Object)cp.getName(), false);
                            cpStateData.setPseudoStateKind(PseudoStateKind.ENTRY);
                            this.stateDatas.add((StateData<String, String>)cpStateData);
                        }
                    }
                    if (cpr.getExits() == null) continue;
                    for (Pseudostate cp : cpr.getExits()) {
                        cpStateData = new StateData((Object)parent, (Object)regionId, (Object)cp.getName(), false);
                        cpStateData.setPseudoStateKind(PseudoStateKind.EXIT);
                        this.stateDatas.add((StateData<String, String>)cpStateData);
                    }
                }
                for (Pseudostate cp : state.getConnectionPoints()) {
                    PseudoStateKind kind = null;
                    if (cp.getKind() == PseudostateKind.ENTRY_POINT_LITERAL) {
                        kind = PseudoStateKind.ENTRY;
                    } else if (cp.getKind() == PseudostateKind.EXIT_POINT_LITERAL) {
                        kind = PseudoStateKind.EXIT;
                    }
                    if (kind == null) continue;
                    StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)cp.getName(), false);
                    cpStateData.setPseudoStateKind(kind);
                    this.stateDatas.add((StateData<String, String>)cpStateData);
                }
                for (Region sub : state.getRegions()) {
                    this.handleRegion(sub);
                }
            }
            if (!(vertex instanceof Pseudostate)) continue;
            state = (Pseudostate)vertex;
            parent = null;
            regionId = null;
            if (state.getContainer().getOwner() instanceof State) {
                parent = ((State)state.getContainer().getOwner()).getName();
            } else if (state.getContainer().getOwner() instanceof StateMachine) {
                StateMachine owningMachine = (StateMachine)state.getContainer().getOwner();
                parent = owningMachine.getSubmachineStates().stream().filter(m -> owningMachine == m.getSubmachine()).map(s -> s.getName()).findFirst().orElse(null);
            }
            if (state.getOwner() instanceof Region) {
                regionId = ((Region)state.getOwner()).getName();
            }
            if (state.getKind() == PseudostateKind.CHOICE_LITERAL) {
                StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)this.resolveName((NamedElement)state), false);
                cpStateData.setPseudoStateKind(PseudoStateKind.CHOICE);
                this.stateDatas.add((StateData<String, String>)cpStateData);
                continue;
            }
            if (state.getKind() == PseudostateKind.JUNCTION_LITERAL) {
                StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)state.getName(), false);
                cpStateData.setPseudoStateKind(PseudoStateKind.JUNCTION);
                this.stateDatas.add((StateData<String, String>)cpStateData);
                continue;
            }
            if (state.getKind() == PseudostateKind.FORK_LITERAL) {
                StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)state.getName(), false);
                cpStateData.setPseudoStateKind(PseudoStateKind.FORK);
                this.stateDatas.add((StateData<String, String>)cpStateData);
                continue;
            }
            if (state.getKind() == PseudostateKind.JOIN_LITERAL) {
                StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)state.getName(), false);
                cpStateData.setPseudoStateKind(PseudoStateKind.JOIN);
                this.stateDatas.add((StateData<String, String>)cpStateData);
                continue;
            }
            if (state.getKind() == PseudostateKind.SHALLOW_HISTORY_LITERAL) {
                StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)state.getName(), false);
                cpStateData.setPseudoStateKind(PseudoStateKind.HISTORY_SHALLOW);
                this.stateDatas.add((StateData<String, String>)cpStateData);
                continue;
            }
            if (state.getKind() != PseudostateKind.DEEP_HISTORY_LITERAL) continue;
            StateData cpStateData = new StateData((Object)parent, (Object)regionId, (Object)state.getName(), false);
            cpStateData.setPseudoStateKind(PseudoStateKind.HISTORY_DEEP);
            this.stateDatas.add((StateData<String, String>)cpStateData);
        }
        for (Transition transition : region.getTransitions()) {
            List<String> list;
            if (transition.getSource() instanceof ConnectionPointReference) {
                EList cprexits;
                EList cprentries = ((ConnectionPointReference)transition.getSource()).getEntries();
                if (cprentries != null && cprentries.size() == 1 && ((Pseudostate)cprentries.get(0)).getKind() == PseudostateKind.ENTRY_POINT_LITERAL) {
                    this.entrys.add((EntryData<String, String>)new EntryData((Object)((Pseudostate)cprentries.get(0)).getName(), (Object)this.resolveName((NamedElement)transition.getTarget())));
                }
                if ((cprexits = ((ConnectionPointReference)transition.getSource()).getExits()) != null && cprexits.size() == 1 && ((Pseudostate)cprexits.get(0)).getKind() == PseudostateKind.EXIT_POINT_LITERAL) {
                    this.exits.add((ExitData<String, String>)new ExitData((Object)((Pseudostate)cprexits.get(0)).getName(), (Object)this.resolveName((NamedElement)transition.getTarget())));
                }
            }
            if (transition.getSource() instanceof Pseudostate) {
                Collection<Action<String, String>> actions;
                Guard<String, String> guard;
                if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.ENTRY_POINT_LITERAL) {
                    this.entrys.add((EntryData<String, String>)new EntryData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget())));
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.EXIT_POINT_LITERAL) {
                    this.exits.add((ExitData<String, String>)new ExitData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget())));
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.CHOICE_LITERAL) {
                    list = this.choices.get(this.resolveName((NamedElement)transition.getSource()));
                    if (list == null) {
                        list = new LinkedList<String>();
                        this.choices.put(this.resolveName((NamedElement)transition.getSource()), (LinkedList<ChoiceData<String, String>>)list);
                    }
                    guard = this.resolveGuard(transition);
                    actions = UmlUtils.resolveTransitionActions(transition, this.resolver);
                    if (guard == null) {
                        ((LinkedList)list).addLast((String)new ChoiceData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), guard, actions));
                    } else {
                        ((LinkedList)list).addFirst((String)new ChoiceData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), guard, actions));
                    }
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.JUNCTION_LITERAL) {
                    list = this.junctions.get(this.resolveName((NamedElement)transition.getSource()));
                    if (list == null) {
                        list = new LinkedList<String>();
                        this.junctions.put(this.resolveName((NamedElement)transition.getSource()), (LinkedList<JunctionData<String, String>>)list);
                    }
                    guard = this.resolveGuard(transition);
                    actions = UmlUtils.resolveTransitionActions(transition, this.resolver);
                    if (guard == null) {
                        ((LinkedList)list).addLast((String)new JunctionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), guard, actions));
                    } else {
                        ((LinkedList)list).addFirst((String)new JunctionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), guard, actions));
                    }
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.FORK_LITERAL) {
                    list = this.forks.get(this.resolveName((NamedElement)transition.getSource()));
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.forks.put(this.resolveName((NamedElement)transition.getSource()), list);
                    }
                    list.add(this.resolveName((NamedElement)transition.getTarget()));
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.SHALLOW_HISTORY_LITERAL) {
                    this.historys.add((HistoryData<String, String>)new HistoryData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget())));
                } else if (((Pseudostate)transition.getSource()).getKind() == PseudostateKind.DEEP_HISTORY_LITERAL) {
                    this.historys.add((HistoryData<String, String>)new HistoryData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget())));
                }
            }
            if (transition.getTarget() instanceof Pseudostate && ((Pseudostate)transition.getTarget()).getKind() == PseudostateKind.JOIN_LITERAL) {
                list = this.joins.get(this.resolveName((NamedElement)transition.getTarget()));
                if (list == null) {
                    list = new ArrayList<String>();
                    this.joins.put(this.resolveName((NamedElement)transition.getTarget()), list);
                }
                list.add(this.resolveName((NamedElement)transition.getSource()));
            }
            for (Trigger trigger : transition.getTriggers()) {
                TimeEvent timeEvent;
                Long period;
                Guard<String, String> guard = this.resolveGuard(transition);
                Event event = trigger.getEvent();
                if (event instanceof SignalEvent) {
                    Signal signal = ((SignalEvent)event).getSignal();
                    if (signal == null) continue;
                    if (transition.getTarget() instanceof ConnectionPointReference) {
                        EList cprentries = ((ConnectionPointReference)transition.getTarget()).getEntries();
                        if (cprentries == null || cprentries.size() != 1) continue;
                        this.transitionDatas.add((TransitionData<String, String>)new TransitionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)((Pseudostate)cprentries.get(0)).getName(), (Object)signal.getName(), UmlUtils.resolveTransitionActions(transition, this.resolver), guard, UmlUtils.mapUmlTransitionType(transition)));
                        continue;
                    }
                    this.transitionDatas.add((TransitionData<String, String>)new TransitionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), (Object)signal.getName(), UmlUtils.resolveTransitionActions(transition, this.resolver), guard, UmlUtils.mapUmlTransitionType(transition)));
                    continue;
                }
                if (!(event instanceof TimeEvent) || (period = this.getTimePeriod(timeEvent = (TimeEvent)event)) == null) continue;
                Integer count = null;
                if (timeEvent.isRelative()) {
                    count = 1;
                }
                this.transitionDatas.add((TransitionData<String, String>)new TransitionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), period, count, UmlUtils.resolveTransitionActions(transition, this.resolver), guard, UmlUtils.mapUmlTransitionType(transition)));
            }
            if (!this.shouldCreateAnonymousTransition(transition)) continue;
            this.transitionDatas.add((TransitionData<String, String>)new TransitionData((Object)this.resolveName((NamedElement)transition.getSource()), (Object)this.resolveName((NamedElement)transition.getTarget()), null, UmlUtils.resolveTransitionActions(transition, this.resolver), this.resolveGuard(transition), UmlUtils.mapUmlTransitionType(transition)));
        }
    }

    private Guard<String, String> resolveGuard(Transition transition) {
        Guard guard = null;
        for (Constraint c : transition.getOwnedRules()) {
            if (!(c.getSpecification() instanceof OpaqueExpression)) continue;
            String beanId = UmlUtils.resolveBodyByLanguage(LANGUAGE_BEAN, (BodyOwner)((OpaqueExpression)c.getSpecification()));
            if (StringUtils.hasText((String)beanId)) {
                guard = this.resolver.resolveGuard(beanId);
                continue;
            }
            String expression = UmlUtils.resolveBodyByLanguage(LANGUAGE_SPEL, (BodyOwner)((OpaqueExpression)c.getSpecification()));
            if (!StringUtils.hasText((String)expression)) continue;
            SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
            guard = new SpelExpressionGuard(parser.parseExpression(expression));
        }
        return guard;
    }

    private Long getTimePeriod(TimeEvent event) {
        try {
            return event.getWhen().getExpr().integerValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Action<String, String> resolveInitialTransitionAction(State state) {
        Transition transition = UmlUtils.resolveInitialTransition(state);
        if (transition != null) {
            return UmlUtils.resolveTransitionAction(transition, this.resolver);
        }
        return null;
    }

    private boolean shouldCreateAnonymousTransition(Transition transition) {
        if (transition.getSource() == null || transition.getTarget() == null) {
            return false;
        }
        if (!transition.getTriggers().isEmpty()) {
            return false;
        }
        if (!StringUtils.hasText((String)this.resolveName((NamedElement)transition.getSource()))) {
            return false;
        }
        if (!StringUtils.hasText((String)this.resolveName((NamedElement)transition.getTarget()))) {
            return false;
        }
        if (transition.getSource() instanceof Pseudostate && ((Pseudostate)transition.getSource()).getKind() == PseudostateKind.FORK_LITERAL) {
            return false;
        }
        return !(transition.getTarget() instanceof Pseudostate) || ((Pseudostate)transition.getTarget()).getKind() != PseudostateKind.JOIN_LITERAL;
    }

    private StateData<String, String> handleActions(StateData<String, String> stateData, State state) {
        ArrayList<Action> stateActions;
        ArrayList<Action> exits;
        SpelExpressionParser parser;
        String expression;
        ArrayList<Action> entrys;
        Action bean;
        String beanId;
        if (state.getEntry() instanceof OpaqueBehavior) {
            beanId = UmlUtils.resolveBodyByLanguage(LANGUAGE_BEAN, (BodyOwner)((OpaqueBehavior)state.getEntry()));
            if (StringUtils.hasText((String)beanId)) {
                bean = this.resolver.resolveAction(beanId);
                if (bean != null) {
                    entrys = new ArrayList<Action>();
                    entrys.add(bean);
                    stateData.setEntryActions(entrys);
                }
            } else {
                expression = UmlUtils.resolveBodyByLanguage(LANGUAGE_SPEL, (BodyOwner)((OpaqueBehavior)state.getEntry()));
                if (StringUtils.hasText((String)expression)) {
                    parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    ArrayList<SpelExpressionAction> entrys2 = new ArrayList<SpelExpressionAction>();
                    entrys2.add(new SpelExpressionAction(parser.parseExpression(expression)));
                    stateData.setEntryActions(entrys2);
                }
            }
        }
        if (state.getExit() instanceof OpaqueBehavior) {
            beanId = UmlUtils.resolveBodyByLanguage(LANGUAGE_BEAN, (BodyOwner)((OpaqueBehavior)state.getExit()));
            if (StringUtils.hasText((String)beanId)) {
                bean = this.resolver.resolveAction(beanId);
                if (bean != null) {
                    exits = new ArrayList<Action>();
                    exits.add(bean);
                    stateData.setExitActions(exits);
                }
            } else {
                expression = UmlUtils.resolveBodyByLanguage(LANGUAGE_SPEL, (BodyOwner)((OpaqueBehavior)state.getExit()));
                if (StringUtils.hasText((String)expression)) {
                    parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    ArrayList<SpelExpressionAction> exits2 = new ArrayList<SpelExpressionAction>();
                    exits2.add(new SpelExpressionAction(parser.parseExpression(expression)));
                    stateData.setExitActions(exits2);
                }
            }
        }
        if (state.getDoActivity() instanceof OpaqueBehavior) {
            beanId = UmlUtils.resolveBodyByLanguage(LANGUAGE_BEAN, (BodyOwner)((OpaqueBehavior)state.getDoActivity()));
            if (StringUtils.hasText((String)beanId)) {
                bean = this.resolver.resolveAction(beanId);
                if (bean != null) {
                    stateActions = new ArrayList<Action>();
                    stateActions.add(bean);
                    stateData.setStateActions(stateActions);
                }
            } else {
                expression = UmlUtils.resolveBodyByLanguage(LANGUAGE_SPEL, (BodyOwner)((OpaqueBehavior)state.getDoActivity()));
                if (StringUtils.hasText((String)expression)) {
                    parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    ArrayList<SpelExpressionAction> stateActions2 = new ArrayList<SpelExpressionAction>();
                    stateActions2.add(new SpelExpressionAction(parser.parseExpression(expression)));
                    stateData.setStateActions(stateActions2);
                }
            }
        }
        if (state.getEntry() instanceof Activity && (bean = this.resolver.resolveAction(beanId = ((Activity)state.getEntry()).getName())) != null) {
            entrys = new ArrayList();
            entrys.add(bean);
            stateData.setEntryActions(entrys);
        }
        if (state.getExit() instanceof Activity && (bean = this.resolver.resolveAction(beanId = ((Activity)state.getExit()).getName())) != null) {
            exits = new ArrayList();
            exits.add(bean);
            stateData.setExitActions(exits);
        }
        if (state.getDoActivity() instanceof Activity && (bean = this.resolver.resolveAction(beanId = ((Activity)state.getDoActivity()).getName())) != null) {
            stateActions = new ArrayList();
            stateActions.add(bean);
            stateData.setStateActions(stateActions);
        }
        return stateData;
    }

    public class DataHolder {
        private final StatesData<String, String> statesData;
        private final TransitionsData<String, String> transitionsData;

        public DataHolder(StatesData<String, String> statesData, TransitionsData<String, String> transitionsData) {
            this.statesData = statesData;
            this.transitionsData = transitionsData;
        }

        public StatesData<String, String> getStatesData() {
            return this.statesData;
        }

        public TransitionsData<String, String> getTransitionsData() {
            return this.transitionsData;
        }
    }
}

