/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;

public class SquirrelSingletonProvider
implements SquirrelComponent,
SquirrelSingleton {
    private static SquirrelSingletonProvider instance = new SquirrelSingletonProvider();
    private Map<String, Object> instanceRegistry = new ConcurrentHashMap<String, Object>();

    public static SquirrelSingletonProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelSingletonProvider instance) {
        SquirrelSingletonProvider.instance = instance;
    }

    public <T> void register(Class<T> componentClass, Object instance) {
        Preconditions.checkArgument((boolean)componentClass.isAssignableFrom(instance.getClass()));
        this.instanceRegistry.put(componentClass.getName(), instance);
    }

    public void unregister(Class<?> componentClass) {
        this.instanceRegistry.remove(componentClass.getName());
    }

    public void clearRegistry() {
        this.instanceRegistry.clear();
    }

    public <T> T get(Class<T> componentClass) {
        Object instance = this.instanceRegistry.get(componentClass.getName());
        if (instance == null) {
            try {
                instance = SquirrelProvider.getInstance().newInstance(componentClass);
            }
            catch (Exception e) {
                instance = null;
            }
            if (instance != null) {
                this.register(componentClass, instance);
            }
        }
        return instance != null ? (T)componentClass.cast(instance) : null;
    }
}

