/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.event;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.event.AsyncEventListener;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.util.ReflectUtils;

public class ListenerMethod {
    private final Class<?> eventType;
    private final Object target;
    private final Method method;
    private boolean hasParameter = false;
    private final boolean isAsync;
    private final long timeout;

    public ListenerMethod(Class<?> eventType, Object listener, Method method) {
        Preconditions.checkArgument((eventType != null && listener != null && method != null ? 1 : 0) != 0, (Object)"Parameters cannot be null.");
        Preconditions.checkArgument((boolean)method.getDeclaringClass().isAssignableFrom(listener.getClass()), (Object)("The method " + method.getName() + " cannot be used for the given target: " + listener.getClass().getName()));
        this.eventType = eventType;
        this.target = listener;
        this.method = method;
        this.isAsync = AsyncEventListener.class.isAssignableFrom(listener.getClass());
        this.timeout = this.isAsync ? ((AsyncEventListener)AsyncEventListener.class.cast(listener)).timeout() : -1L;
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 0) {
            if (params.length == 1 && params[0].isAssignableFrom(eventType)) {
                this.hasParameter = true;
            } else {
                throw new SquirrelRuntimeException(ErrorCodes.METHOD_UNEXPECTED_PARAMETERS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeMethod(final Object event) {
        Preconditions.checkArgument((boolean)this.eventType.isAssignableFrom(event.getClass()));
        if (this.isAsync) {
            SquirrelConfiguration.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray;
                    Method method = ListenerMethod.this.method;
                    Object object = ListenerMethod.this.target;
                    if (ListenerMethod.this.hasParameter) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = event;
                    } else {
                        objectArray = new Object[]{};
                    }
                    ReflectUtils.invoke(method, object, objectArray);
                }
            });
        } else {
            Object object = this.target;
            synchronized (object) {
                Object[] objectArray;
                if (this.hasParameter) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = event;
                } else {
                    objectArray = new Object[]{};
                }
                ReflectUtils.invoke(this.method, this.target, objectArray);
            }
        }
    }

    public boolean matches(Class<?> eventType, Object target) {
        return this.target == target && eventType.equals(this.eventType);
    }

    public boolean matches(Class<?> eventType, Object target, Method method) {
        return this.target == target && eventType.equals(this.eventType) && method.equals(this.method);
    }

    public int hashCode() {
        int hash = this.eventType.hashCode();
        hash = 17 * hash + this.target.hashCode();
        hash = 17 * hash + this.method.hashCode();
        return hash;
    }

    public Class<?> getEventType() {
        return this.eventType;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ListenerMethod t = (ListenerMethod)obj;
        return (this.eventType == t.eventType || this.eventType != null && this.eventType.equals(t.eventType)) && (this.target == t.target || this.target != null && this.target.equals(t.target)) && (this.method == t.method || this.method != null && this.method.equals(t.method));
    }

    public String toString() {
        return this.target.getClass().getSimpleName() + '.' + this.method.getName() + '(' + this.eventType.getSimpleName() + ')';
    }
}

