/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;

class MvelActionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(MvelActionImpl.class);
    private final String mvelExpression;
    private final MvelScriptManager scriptManager;
    private final String name;
    private final String script;

    MvelActionImpl(String script, ExecutionContext executionContext) {
        Preconditions.checkNotNull((Object)script);
        String[] arrays = StringUtils.split((String)script, (String)":::");
        if (arrays.length == 2) {
            this.name = arrays[0].trim();
            this.mvelExpression = arrays[1].trim();
        } else {
            this.name = "_NoName_";
            this.mvelExpression = arrays[0].trim();
        }
        this.script = script;
        this.scriptManager = executionContext.getScriptManager();
        this.scriptManager.compile(this.mvelExpression);
    }

    @Override
    public void execute(S from, S to, E event, C context, T stateMachine) {
        try {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("from", from);
            variables.put("to", to);
            variables.put("event", event);
            variables.put("context", context);
            variables.put("stateMachine", stateMachine);
            this.scriptManager.eval(this.mvelExpression, variables, Void.class);
        }
        catch (RuntimeException e) {
            logger.error("Evaluate \"" + this.mvelExpression + "\" failed, which caused by " + e.getCause().getMessage());
            throw e;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int weight() {
        return 0;
    }

    public final String toString() {
        return "mvel#" + this.script;
    }

    public int hashCode() {
        int result = 1;
        result = 31 + this.mvelExpression.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MvelActionImpl other = (MvelActionImpl)obj;
        if (this.mvelExpression == null ? other.mvelExpression != null : !this.mvelExpression.equals(other.mvelExpression)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public long timeout() {
        return -1L;
    }
}

