/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIAutoConfiguration;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.parsing.ast.statement.ClassConverter;

@Configuration
@AutoConfigureBefore(value={MagicAPIAutoConfiguration.class})
public class MagicJsonAutoConfiguration {
    private static void register(Function<String, Object> processString, Function<byte[], Object> processBytes, Function<Object, String> stringify) {
        MagicJsonAutoConfiguration.register(processString, processBytes, IoUtils::bytes, stringify);
    }

    private static void register(Function<String, Object> processString, Function<byte[], Object> processBytes, Function<InputStream, Object> processInputStream, Function<Object, String> stringify) {
        ClassConverter.register((String)"json", (value, params) -> {
            if (value == null) {
                return params != null && ((Object[])params).length > 0 ? params[0] : null;
            }
            if (value instanceof CharSequence) {
                return processString.apply(value.toString());
            }
            if (value instanceof byte[]) {
                return processBytes.apply((byte[])value);
            }
            if (value instanceof InputStream) {
                return processInputStream.apply((InputStream)value);
            }
            throw new MagicScriptException(String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:%s", value.getClass()));
        });
        ClassConverter.register((String)"stringify", (value, params) -> {
            if (value == null) {
                return params != null && ((Object[])params).length > 0 ? params[0] : null;
            }
            return stringify.apply(value);
        });
    }

    @ConditionalOnMissingBean(value={ObjectMapper.class})
    @ConditionalOnClass(value={JSON.class})
    @Configuration
    static class MagicFastJsonAutoConfiguration {
        MagicFastJsonAutoConfiguration() {
            MagicJsonAutoConfiguration.register(JSON::parse, x$0 -> JSON.parse((byte[])x$0, (Feature[])new Feature[0]), JSON::toJSONString);
        }
    }

    @ConditionalOnBean(value={ObjectMapper.class})
    @Configuration
    static class MagicJacksonAutoConfiguration {
        MagicJacksonAutoConfiguration(ObjectMapper objectMapper) {
            MagicJsonAutoConfiguration.register(str -> {
                try {
                    return objectMapper.readValue(str, Object.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, bytes -> {
                try {
                    return objectMapper.readValue(bytes, Object.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, is -> {
                try {
                    return objectMapper.readValue(is, Object.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, object -> {
                try {
                    return objectMapper.writeValueAsString(object);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

