/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartResolver;
import org.ssssssss.magicapi.core.config.Cache;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.Page;
import org.ssssssss.magicapi.core.interceptor.DefaultResultProvider;
import org.ssssssss.magicapi.core.interceptor.ResultProvider;
import org.ssssssss.magicapi.core.servlet.MagicRequestContextHolder;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;
import org.ssssssss.magicapi.jsr223.JSR223LanguageProvider;
import org.ssssssss.magicapi.modules.db.ColumnMapperAdapter;
import org.ssssssss.magicapi.modules.db.SQLModule;
import org.ssssssss.magicapi.modules.db.cache.DefaultSqlCache;
import org.ssssssss.magicapi.modules.db.cache.SqlCache;
import org.ssssssss.magicapi.modules.db.dialect.Dialect;
import org.ssssssss.magicapi.modules.db.dialect.DialectAdapter;
import org.ssssssss.magicapi.modules.db.inteceptor.DefaultSqlInterceptor;
import org.ssssssss.magicapi.modules.db.inteceptor.NamedTableInterceptor;
import org.ssssssss.magicapi.modules.db.inteceptor.SQLInterceptor;
import org.ssssssss.magicapi.modules.db.provider.ColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.DefaultPageProvider;
import org.ssssssss.magicapi.modules.db.provider.PageProvider;
import org.ssssssss.magicapi.modules.http.HttpModule;
import org.ssssssss.magicapi.modules.servlet.RequestModule;
import org.ssssssss.magicapi.modules.servlet.ResponseModule;
import org.ssssssss.magicapi.modules.spring.EnvModule;

public class MagicModuleConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MagicModuleConfiguration.class);
    private final MagicAPIProperties properties;
    private final ObjectProvider<List<SQLInterceptor>> sqlInterceptorsProvider;
    private final ObjectProvider<List<NamedTableInterceptor>> namedTableInterceptorsProvider;
    private final ObjectProvider<List<Dialect>> dialectsProvider;
    private final ObjectProvider<List<ColumnMapperProvider>> columnMapperProvidersProvider;
    private final Environment environment;
    @Autowired(required=false)
    private MultipartResolver multipartResolver;

    public MagicModuleConfiguration(MagicAPIProperties properties, ObjectProvider<List<SQLInterceptor>> sqlInterceptorsProvider, ObjectProvider<List<NamedTableInterceptor>> namedTableInterceptorsProvider, ObjectProvider<List<Dialect>> dialectsProvider, ObjectProvider<List<ColumnMapperProvider>> columnMapperProvidersProvider, Environment environment) {
        this.properties = properties;
        this.sqlInterceptorsProvider = sqlInterceptorsProvider;
        this.namedTableInterceptorsProvider = namedTableInterceptorsProvider;
        this.dialectsProvider = dialectsProvider;
        this.columnMapperProvidersProvider = columnMapperProvidersProvider;
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicDynamicDataSource.class})
    public MagicDynamicDataSource magicDynamicDataSource(@Autowired(required=false) DataSource dataSource) {
        MagicDynamicDataSource dynamicDataSource = new MagicDynamicDataSource();
        if (dataSource != null) {
            dynamicDataSource.put(dataSource);
        } else {
            logger.warn("\u5f53\u524d\u6570\u636e\u6e90\u672a\u914d\u7f6e");
        }
        return dynamicDataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={PageProvider.class})
    public PageProvider pageProvider() {
        Page pageConfig = this.properties.getPage();
        logger.info("\u672a\u627e\u5230\u5206\u9875\u5b9e\u73b0,\u91c7\u7528\u9ed8\u8ba4\u5206\u9875\u5b9e\u73b0,\u5206\u9875\u914d\u7f6e:(\u9875\u7801={},\u9875\u5927\u5c0f={},\u9ed8\u8ba4\u9996\u9875={},\u9ed8\u8ba4\u9875\u5927\u5c0f={},\u6700\u5927\u9875\u5927\u5c0f={})", new Object[]{pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize(), pageConfig.getMaxPageSize()});
        return new DefaultPageProvider(pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize(), pageConfig.getMaxPageSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlCache.class})
    public SqlCache sqlCache() {
        Cache cacheConfig = this.properties.getCache();
        logger.info("\u672a\u627e\u5230SQL\u7f13\u5b58\u5b9e\u73b0\uff0c\u91c7\u7528\u9ed8\u8ba4\u7f13\u5b58\u5b9e\u73b0(LRU+TTL)\uff0c\u7f13\u5b58\u914d\u7f6e:(\u5bb9\u91cf={},TTL={})", (Object)cacheConfig.getCapacity(), (Object)cacheConfig.getTtl());
        return new DefaultSqlCache(cacheConfig.getCapacity(), cacheConfig.getTtl());
    }

    @Bean
    @ConditionalOnBean(value={MagicDynamicDataSource.class})
    public SQLModule magicSqlModule(MagicDynamicDataSource dynamicDataSource, ResultProvider resultProvider, PageProvider pageProvider, SqlCache sqlCache) {
        SQLModule sqlModule = new SQLModule(dynamicDataSource);
        if (!dynamicDataSource.isEmpty()) {
            sqlModule.setDataSourceNode(dynamicDataSource.getDataSource());
        }
        sqlModule.setResultProvider(resultProvider);
        sqlModule.setPageProvider(pageProvider);
        List sqlInterceptors = (List)this.sqlInterceptorsProvider.getIfAvailable(ArrayList::new);
        if (this.properties.isShowSql()) {
            sqlInterceptors.add(new DefaultSqlInterceptor());
        }
        sqlModule.setSqlInterceptors(sqlInterceptors);
        sqlModule.setNamedTableInterceptors((List)this.namedTableInterceptorsProvider.getIfAvailable(Collections::emptyList));
        ColumnMapperAdapter columnMapperAdapter = new ColumnMapperAdapter();
        ((List)this.columnMapperProvidersProvider.getIfAvailable(Collections::emptyList)).stream().filter(mapperProvider -> !"default".equals(mapperProvider.name())).forEach(arg_0 -> ((ColumnMapperAdapter)columnMapperAdapter).add(arg_0));
        columnMapperAdapter.setDefault(this.properties.getSqlColumnCase());
        sqlModule.setColumnMapperProvider(columnMapperAdapter);
        sqlModule.setColumnMapRowMapper(columnMapperAdapter.getDefaultColumnMapRowMapper());
        sqlModule.setRowMapColumnMapper(columnMapperAdapter.getDefaultRowMapColumnMapper());
        sqlModule.setSqlCache(sqlCache);
        DialectAdapter dialectAdapter = new DialectAdapter();
        ((List)this.dialectsProvider.getIfAvailable(Collections::emptyList)).forEach(arg_0 -> ((DialectAdapter)dialectAdapter).add(arg_0));
        sqlModule.setDialectAdapter(dialectAdapter);
        sqlModule.setLogicDeleteColumn(this.properties.getCrud().getLogicDeleteColumn());
        sqlModule.setLogicDeleteValue(this.properties.getCrud().getLogicDeleteValue());
        return sqlModule;
    }

    @Bean
    public JSR223LanguageProvider jsr223LanguageProvider() {
        return new JSR223LanguageProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpModule.class})
    public HttpModule magicHttpModule() {
        return new HttpModule(this.createRestTemplate());
    }

    @Bean
    @ConditionalOnMissingBean
    public EnvModule magicEnvModule() {
        return new EnvModule(this.environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestModule magicRequestModule(MagicRequestContextHolder magicRequestContextHolder) {
        return new RequestModule(magicRequestContextHolder);
    }

    @Bean
    @ConditionalOnMissingBean(value={ResultProvider.class})
    public ResultProvider resultProvider() {
        return new DefaultResultProvider(this.properties.getResponse());
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseModule magicResponseModule(ResultProvider resultProvider) {
        return new ResponseModule(resultProvider);
    }

    private RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new StringHttpMessageConverter(StandardCharsets.UTF_8){
            {
                this.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
            }

            public boolean supports(Class<?> clazz) {
                return true;
            }
        });
        return restTemplate;
    }
}

