/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.BufferType;
import org.tio.core.ssl.facade.BufferUtils;
import org.tio.core.ssl.facade.Buffers;
import org.tio.core.ssl.facade.DefaultOnCloseListener;
import org.tio.core.ssl.facade.ISSLListener;
import org.tio.core.ssl.facade.ISessionClosedListener;
import org.tio.core.ssl.facade.SSLLog;
import org.tio.utils.hutool.StrUtil;

class Worker {
    private static Logger log = LoggerFactory.getLogger(Worker.class);
    private static final String TAG = "Worker";
    private final SSLEngine _engine;
    private final Buffers _buffers;
    private ISSLListener _sslListener;
    private ISessionClosedListener _sessionClosedListener = new DefaultOnCloseListener();
    private String who;
    private ChannelContext channelContext;

    Worker(String debugTag, SSLEngine engine, Buffers buffers, ChannelContext channelContext) {
        this._engine = engine;
        this._buffers = buffers;
        this.channelContext = channelContext;
        this.who = "[Worker:" + debugTag + "]";
    }

    private void debug(String msg, String ... args) {
        SSLLog.debug(TAG, msg, args);
    }

    void setSessionClosedListener(ISessionClosedListener scl) {
        this._sessionClosedListener = scl;
    }

    void beginHandshake() throws SSLException {
        this._engine.beginHandshake();
    }

    SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this._engine.getHandshakeStatus();
    }

    Runnable getDelegatedTask() {
        return this._engine.getDelegatedTask();
    }

    SSLEngineResult wrap(SslVo sslVo, ByteBuffer plainData) throws SSLException {
        this._buffers.prepareForWrap(plainData);
        SSLEngineResult result = this.doWrap();
        this.emitWrappedData(sslVo, result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new RuntimeException("BUFFER_UNDERFLOW while wrapping!");
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.OUT_CIPHER);
                if (plainData == null || !plainData.hasRemaining()) break;
                plainData.position(result.bytesConsumed());
                ByteBuffer remainingData = BufferUtils.slice(plainData);
                this.wrap(sslVo, remainingData);
                break;
            }
            case OK: {
                break;
            }
            case CLOSED: {
                this._sessionClosedListener.onSessionClosed();
            }
        }
        return result;
    }

    SSLEngineResult unwrap(ByteBuffer encryptedData) throws SSLException {
        ByteBuffer allEncryptedData = this._buffers.prependCached(encryptedData);
        this._buffers.prepareForUnwrap(allEncryptedData);
        SSLEngineResult result = this.doUnwrap();
        allEncryptedData.position(result.bytesConsumed());
        ByteBuffer unprocessedEncryptedData = BufferUtils.slice(allEncryptedData);
        this.emitPlainData(result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.IN_PLAIN);
                if (unprocessedEncryptedData == null) {
                    throw new RuntimeException("Worker.unwrap had buffer_overflow but all data was consumed!!");
                }
                this.unwrap(unprocessedEncryptedData);
                break;
            }
            case OK: {
                if (unprocessedEncryptedData == null) {
                    this._buffers.clearCache();
                    break;
                }
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
            case CLOSED: {
                this._sessionClosedListener.onSessionClosed();
            }
        }
        if (!this._buffers.isCacheEmpty() && result.getStatus() == SSLEngineResult.Status.OK && result.bytesConsumed() > 0) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            result = this.unwrap(byteBuffer);
        }
        return result;
    }

    void setSSLListener(ISSLListener SSLListener) {
        this._sslListener = SSLListener;
    }

    void handleEnOfSession(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this._sessionClosedListener.onSessionClosed();
        }
    }

    void close(boolean properly) {
        this._engine.closeOutbound();
        try {
            if (properly) {
                this.wrap(new SslVo(), null);
            }
            this._engine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    boolean isCloseCompleted() {
        return this._engine.isOutboundDone();
    }

    boolean pendingUnwrap() {
        return !this._buffers.isCacheEmpty();
    }

    private void emitWrappedData(SslVo sslVo, SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalCipherBuffer = this._buffers.get(BufferType.OUT_CIPHER);
            sslVo.setByteBuffer(Worker.makeExternalBuffer(internalCipherBuffer));
            this._sslListener.onWrappedData(sslVo);
        }
    }

    private void emitPlainData(SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalPlainBuffer = this._buffers.get(BufferType.IN_PLAIN);
            ByteBuffer plainBuffer = Worker.makeExternalBuffer(internalPlainBuffer);
            this._sslListener.onPlainData(plainBuffer);
        }
    }

    private SSLEngineResult doWrap() throws SSLException {
        ByteBuffer plainText = this._buffers.get(BufferType.OUT_PLAIN);
        ByteBuffer cipherText = this._buffers.get(BufferType.OUT_CIPHER);
        if (log.isInfoEnabled()) {
            log.info("{}, doWrap(\u52a0\u5bc6): plainText:{} to cipherText: {}", new Object[]{this.channelContext, plainText, cipherText});
        }
        return this._engine.wrap(plainText, cipherText);
    }

    private SSLEngineResult doUnwrap() throws SSLException {
        ByteBuffer cipherText = this._buffers.get(BufferType.IN_CIPHER);
        ByteBuffer plainText = this._buffers.get(BufferType.IN_PLAIN);
        try {
            log.info("{}, doUnwrap(\u89e3\u5bc6): \u5bc6\u6587buffer:{}, \u660e\u6587buffer: {}", new Object[]{this.channelContext, cipherText, plainText});
            return this._engine.unwrap(cipherText, plainText);
        }
        catch (SSLException e) {
            if (log.isInfoEnabled()) {
                byte[] bs = new byte[cipherText.limit()];
                System.arraycopy(cipherText.array(), 0, bs, 0, bs.length);
                log.error((Object)((Object)this.channelContext) + ", \u89e3\u5bc6Error:" + e.toString() + ", byte:" + StrUtil.arrayToString((Object)bs) + ", string:" + new String(bs) + ", buffer:" + cipherText, (Throwable)e);
            }
            throw e;
        }
    }

    private static ByteBuffer makeExternalBuffer(ByteBuffer internalBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(internalBuffer.position());
        internalBuffer.flip();
        BufferUtils.copy(internalBuffer, newBuffer);
        return newBuffer;
    }
}

