/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.handler;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.RequestLine;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.intf.CurrUseridGetter;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.ThrowableHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.mvc.intf.ControllerFactory;
import org.tio.http.server.session.HttpSessionListener;
import org.tio.http.server.session.SessionCookieDecorator;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.ip.path.IpAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStats;
import org.tio.http.server.stat.token.TokenAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.http.server.stat.token.TokenPathAccessStats;
import org.tio.http.server.util.Resps;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.hutool.ArrayUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.hutool.Validator;

public class DefaultHttpRequestHandler
implements HttpRequestHandler {
    private static Logger log = LoggerFactory.getLogger(DefaultHttpRequestHandler.class);
    private static final String STATIC_RES_CONTENT_CACHENAME = "TIO_HTTP_STATIC_RES_CONTENT";
    private static final String SESSIONRATELIMITER_CACHENAME = "TIO_HTTP_SESSIONRATELIMITER_CACHENAME";
    private static final String SESSION_COOKIE_KEY = "TIO_HTTP_SESSION_COOKIE";
    private static final Map<Class<?>, MethodAccess> CLASS_METHODACCESS_MAP = new HashMap();
    protected HttpConfig httpConfig;
    protected Routes routes = null;
    private HttpServerInterceptor httpServerInterceptor;
    private HttpSessionListener httpSessionListener;
    private ThrowableHandler throwableHandler;
    private SessionCookieDecorator sessionCookieDecorator;
    private IpPathAccessStats ipPathAccessStats;
    private TokenPathAccessStats tokenPathAccessStats;
    private CaffeineCache staticResCache;
    private CaffeineCache sessionRateLimiterCache;
    private static final String SESSIONRATELIMITER_KEY_SPLIT = "?";
    private String contextPath;
    private int contextPathLength = 0;
    private String suffix;
    private int suffixLength = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodAccess getMethodAccess(Class<?> clazz) {
        MethodAccess ret = CLASS_METHODACCESS_MAP.get(clazz);
        if (ret == null) {
            Map<Class<?>, MethodAccess> map = CLASS_METHODACCESS_MAP;
            synchronized (map) {
                ret = CLASS_METHODACCESS_MAP.get(clazz);
                if (ret == null) {
                    ret = MethodAccess.get(clazz);
                    CLASS_METHODACCESS_MAP.put(clazz, ret);
                }
            }
        }
        return ret;
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Class<?> scanRootClasse) {
        this(httpConfig, new Class[]{scanRootClasse});
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Class<?> scanRootClasse, ControllerFactory controllerFactory) {
        this(httpConfig, new Class[]{scanRootClasse}, controllerFactory);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Class<?>[] scanRootClasses) {
        this(httpConfig, scanRootClasses, null);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Class<?>[] scanRootClasses, ControllerFactory controllerFactory) {
        Routes routes = new Routes(scanRootClasses, controllerFactory);
        this.init(httpConfig, routes);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, String scanPackage) {
        this(httpConfig, scanPackage, null);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, String scanPackage, ControllerFactory controllerFactory) {
        this(httpConfig, new String[]{scanPackage}, controllerFactory);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, String[] scanPackages) {
        this(httpConfig, scanPackages, null);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, String[] scanPackages, ControllerFactory controllerFactory) {
        Routes routes = new Routes(scanPackages, controllerFactory);
        this.init(httpConfig, routes);
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Routes routes) {
        this.init(httpConfig, routes);
    }

    private void init(HttpConfig httpConfig, Routes routes) {
        if (httpConfig == null) {
            throw new RuntimeException("httpConfig can not be null");
        }
        this.contextPath = httpConfig.getContextPath();
        this.suffix = httpConfig.getSuffix();
        if (StrUtil.isNotBlank((CharSequence)this.contextPath)) {
            this.contextPathLength = this.contextPath.length();
        }
        if (StrUtil.isNotBlank((CharSequence)this.suffix)) {
            this.suffixLength = this.suffix.length();
        }
        this.httpConfig = httpConfig;
        if (httpConfig.getMaxLiveTimeOfStaticRes() > 0) {
            this.staticResCache = CaffeineCache.register((String)STATIC_RES_CONTENT_CACHENAME, (Long)Long.valueOf(httpConfig.getMaxLiveTimeOfStaticRes()), null);
        }
        this.sessionRateLimiterCache = CaffeineCache.register((String)SESSIONRATELIMITER_CACHENAME, (Long)60L, null);
        this.routes = routes;
    }

    private HttpSession createSession(HttpRequest request) {
        String sessionId = this.httpConfig.getSessionIdGenerator().sessionId(this.httpConfig, request);
        HttpSession httpSession = new HttpSession(sessionId);
        if (this.httpSessionListener != null) {
            this.httpSessionListener.doAfterCreated(request, httpSession, this.httpConfig);
        }
        return httpSession;
    }

    public HttpConfig getHttpConfig(HttpRequest request) {
        return this.httpConfig;
    }

    public HttpServerInterceptor getHttpServerInterceptor() {
        return this.httpServerInterceptor;
    }

    public static Cookie getSessionCookie(HttpRequest request, HttpConfig httpConfig) {
        Cookie sessionCookie = request.getCookie(httpConfig.getSessionCookieName());
        return sessionCookie;
    }

    public CaffeineCache getStaticResCache() {
        return this.staticResCache;
    }

    private boolean checkDomain(HttpRequest request) {
        Object[] allowDomains = this.httpConfig.getAllowDomains();
        if (allowDomains == null || allowDomains.length == 0) {
            return true;
        }
        String host = request.getHost();
        return ArrayUtil.contains((Object[])allowDomains, (Object)host);
    }

    private Method getMethod(HttpRequest request, RequestLine requestLine) {
        Method method = null;
        String path = requestLine.path;
        if (this.routes != null) {
            method = this.routes.getMethodByPath(path, request);
            path = requestLine.path;
        }
        if (method == null && StrUtil.isNotBlank((CharSequence)this.httpConfig.getWelcomeFile()) && StrUtil.endWith((CharSequence)path, (CharSequence)"/")) {
            path = path + this.httpConfig.getWelcomeFile();
            requestLine.setPath(path);
            if (this.routes != null) {
                method = this.routes.getMethodByPath(path, request);
                path = requestLine.path;
            }
        }
        return method;
    }

    /*
     * Exception decompiling
     */
    public HttpResponse handler(HttpRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 344[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean statIpPath(HttpRequest request, HttpResponse response, String path, long iv) {
        if (this.ipPathAccessStats == null) {
            return true;
        }
        if (response == null) {
            return false;
        }
        if (response.isSkipIpStat() || request.isClosed()) {
            return true;
        }
        String ip = request.getClientIp();
        String sessionId = DefaultHttpRequestHandler.getSessionId(request);
        StatPathFilter statPathFilter = this.ipPathAccessStats.getStatPathFilter();
        for (Long duration : this.ipPathAccessStats.durationList) {
            boolean isContinue;
            IpPathAccessStatListener ipPathAccessStatListener;
            IpAccessStat ipAccessStat = this.ipPathAccessStats.get(duration, ip);
            ipAccessStat.count.incrementAndGet();
            ipAccessStat.timeCost.addAndGet(iv);
            ipAccessStat.setLastAccessTime(SystemTimer.currTime);
            if (StrUtil.isBlank((CharSequence)sessionId)) {
                ipAccessStat.noSessionCount.incrementAndGet();
            } else {
                ipAccessStat.sessionIds.add((Object)sessionId);
            }
            if (!statPathFilter.filter(path, request, response)) continue;
            IpPathAccessStat ipPathAccessStat = ipAccessStat.get(path);
            ipPathAccessStat.count.incrementAndGet();
            ipPathAccessStat.timeCost.addAndGet(iv);
            ipPathAccessStat.setLastAccessTime(SystemTimer.currTime);
            if (StrUtil.isBlank((CharSequence)sessionId)) {
                ipPathAccessStat.noSessionCount.incrementAndGet();
            }
            if ((ipPathAccessStatListener = this.ipPathAccessStats.getListener(duration)) == null || (isContinue = ipPathAccessStatListener.onChanged(request, ip, path, ipAccessStat, ipPathAccessStat))) continue;
            return false;
        }
        return true;
    }

    private boolean statTokenPath(HttpRequest request, HttpResponse response, String path, long iv) {
        if (this.tokenPathAccessStats == null) {
            return true;
        }
        if (response == null) {
            return false;
        }
        if (response.isSkipTokenStat() || request.isClosed()) {
            return true;
        }
        String token = this.tokenPathAccessStats.getTokenGetter().getToken(request);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            List<Long> list = this.tokenPathAccessStats.durationList;
            CurrUseridGetter currUseridGetter = this.tokenPathAccessStats.getCurrUseridGetter();
            String uid = null;
            if (currUseridGetter != null) {
                uid = currUseridGetter.getUserid(request);
            }
            StatPathFilter statPathFilter = this.tokenPathAccessStats.getStatPathFilter();
            for (Long duration : list) {
                boolean isContinue;
                TokenAccessStat tokenAccessStat = this.tokenPathAccessStats.get(duration, token, request.getClientIp(), uid);
                tokenAccessStat.count.incrementAndGet();
                tokenAccessStat.timeCost.addAndGet(iv);
                tokenAccessStat.setLastAccessTime(SystemTimer.currTime);
                if (!statPathFilter.filter(path, request, response)) continue;
                TokenPathAccessStat tokenPathAccessStat = tokenAccessStat.get(path);
                tokenPathAccessStat.count.incrementAndGet();
                tokenPathAccessStat.timeCost.addAndGet(iv);
                tokenPathAccessStat.setLastAccessTime(SystemTimer.currTime);
                TokenPathAccessStatListener tokenPathAccessStatListener = this.tokenPathAccessStats.getListener(duration);
                if (tokenPathAccessStatListener == null || (isContinue = tokenPathAccessStatListener.onChanged(request, token, path, tokenAccessStat, tokenPathAccessStat))) continue;
                return false;
            }
        }
        return true;
    }

    private void logError(HttpRequest request, RequestLine requestLine, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("remote  :").append(request.getClientIp());
        sb.append("\r\n").append("request :").append(requestLine.toString());
        log.error(sb.toString(), e);
    }

    private void processCookieAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse httpResponse) throws ExecutionException {
        if (httpResponse == null) {
            return;
        }
        if (!this.httpConfig.isUseSession()) {
            return;
        }
        HttpSession httpSession = request.getHttpSession();
        String sessionId = DefaultHttpRequestHandler.getSessionId(request);
        if (StrUtil.isBlank((CharSequence)sessionId)) {
            this.createSessionCookie(request, httpSession, httpResponse);
        } else {
            HttpSession httpSession1 = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession1 == null) {
                this.createSessionCookie(request, httpSession, httpResponse);
            }
        }
    }

    private void createSessionCookie(HttpRequest request, HttpSession httpSession, HttpResponse httpResponse) {
        String[] dms;
        if (httpResponse == null) {
            return;
        }
        Object test = request.channelContext.getAttribute(SESSION_COOKIE_KEY);
        if (test != null) {
            return;
        }
        String sessionId = httpSession.getId();
        String domain = request.getDomain();
        boolean isip = Validator.isIpv4((String)domain);
        if (!isip && (dms = StrUtil.split((String)domain, (String)".")).length > 2) {
            domain = "." + dms[dms.length - 2] + "." + dms[dms.length - 1];
        }
        String name = this.httpConfig.getSessionCookieName();
        long maxAge = 315360000L;
        Cookie sessionCookie = new Cookie(domain, name, sessionId, Long.valueOf(maxAge));
        if (this.sessionCookieDecorator != null) {
            this.sessionCookieDecorator.decorate(sessionCookie, request, request.getDomain());
        }
        httpResponse.addCookie(sessionCookie);
        this.httpConfig.getSessionStore().put(sessionId, (Serializable)httpSession);
        request.channelContext.setAttribute(SESSION_COOKIE_KEY, (Object)sessionCookie);
    }

    private void processCookieBeforeHandler(HttpRequest request, RequestLine requestLine) throws ExecutionException {
        if (!this.httpConfig.isUseSession()) {
            return;
        }
        String sessionId = DefaultHttpRequestHandler.getSessionId(request);
        HttpSession httpSession = null;
        if (StrUtil.isBlank((CharSequence)sessionId)) {
            httpSession = this.createSession(request);
        } else {
            httpSession = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession == null) {
                log.info("{} session\u3010{}\u3011\u8d85\u65f6", (Object)request.channelContext, (Object)sessionId);
                httpSession = this.createSession(request);
            }
        }
        request.setHttpSession(httpSession);
    }

    public static String getSessionId(HttpRequest request) {
        String sessionId = request.getString("tio_http_sessionid");
        if (StrUtil.isNotBlank((CharSequence)sessionId)) {
            return sessionId;
        }
        Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, request.httpConfig);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) throws Exception {
        String page404;
        Method method;
        if (this.routes != null && (method = this.routes.PATH_METHOD_MAP.get(page404 = this.httpConfig.getPage404())) != null) {
            return Resps.forward(request, page404);
        }
        return Resps.resp404(request, requestLine, this.httpConfig);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) throws Exception {
        String page500;
        Method method;
        if (this.throwableHandler != null) {
            return this.throwableHandler.handler(request, requestLine, throwable);
        }
        if (this.routes != null && (method = this.routes.PATH_METHOD_MAP.get(page500 = this.httpConfig.getPage500())) != null) {
            return Resps.forward(request, page500);
        }
        return Resps.resp500(request, requestLine, this.httpConfig, throwable);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpServerInterceptor(HttpServerInterceptor httpServerInterceptor) {
        this.httpServerInterceptor = httpServerInterceptor;
    }

    public void setStaticResCache(CaffeineCache staticResCache) {
        this.staticResCache = staticResCache;
    }

    public void clearStaticResCache() {
        if (this.staticResCache != null) {
            this.staticResCache.clear();
        }
    }

    public HttpSessionListener getHttpSessionListener() {
        return this.httpSessionListener;
    }

    public void setHttpSessionListener(HttpSessionListener httpSessionListener) {
        this.httpSessionListener = httpSessionListener;
    }

    public SessionCookieDecorator getSessionCookieDecorator() {
        return this.sessionCookieDecorator;
    }

    public void setSessionCookieDecorator(SessionCookieDecorator sessionCookieDecorator) {
        this.sessionCookieDecorator = sessionCookieDecorator;
    }

    public IpPathAccessStats getIpPathAccessStats() {
        return this.ipPathAccessStats;
    }

    public void setIpPathAccessStats(IpPathAccessStats ipPathAccessStats) {
        this.ipPathAccessStats = ipPathAccessStats;
    }

    public ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    public TokenPathAccessStats getTokenPathAccessStats() {
        return this.tokenPathAccessStats;
    }

    public void setTokenPathAccessStats(TokenPathAccessStats tokenPathAccessStats) {
        this.tokenPathAccessStats = tokenPathAccessStats;
    }
}

