/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.AbstractOperation;
import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Tensor;

public final class GraphOperation
extends AbstractOperation {
    private final Graph graph;
    private final long unsafeNativeHandle;

    GraphOperation(Graph g, long unsafeNativeHandle) {
        this.graph = g;
        this.unsafeNativeHandle = unsafeNativeHandle;
    }

    @Override
    public String name() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.name(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public String type() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.type(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public int numOutputs() {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.numOutputs(this.getUnsafeNativeHandle());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int outputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.outputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    public int hashCode() {
        return Long.valueOf(this.getUnsafeNativeHandle()).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphOperation)) {
            return false;
        }
        GraphOperation that = (GraphOperation)o;
        if (this.graph != that.graph) {
            return false;
        }
        try (Graph.Reference r = this.graph.ref();){
            boolean bl = this.getUnsafeNativeHandle() == that.getUnsafeNativeHandle();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.inputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    @Override
    long getUnsafeNativeHandle(int outputIdx) {
        return this.getUnsafeNativeHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long[] shape(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            long[] lArray = GraphOperation.shape(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DataType dtype(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            DataType dataType = DataType.fromC(GraphOperation.dtype(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx));
            return dataType;
        }
    }

    @Override
    Tensor<?> tensor(int outputIdx) {
        throw new IllegalStateException("Graph tensors must be fetched by running a session");
    }

    long getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    private static native String name(long var0);

    private static native String type(long var0);

    private static native int numOutputs(long var0);

    private static native int outputListLength(long var0, String var2);

    private static native int inputListLength(long var0, String var2);

    private static native long[] shape(long var0, long var2, int var4);

    private static native int dtype(long var0, long var2, int var4);
}

