/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.image.AdjustContrast;
import org.tensorflow.op.image.AdjustHue;
import org.tensorflow.op.image.AdjustSaturation;
import org.tensorflow.op.image.CropAndResize;
import org.tensorflow.op.image.CropAndResizeGradBoxes;
import org.tensorflow.op.image.CropAndResizeGradImage;
import org.tensorflow.op.image.DecodeAndCropJpeg;
import org.tensorflow.op.image.DecodeBmp;
import org.tensorflow.op.image.DecodeGif;
import org.tensorflow.op.image.DecodeJpeg;
import org.tensorflow.op.image.DecodePng;
import org.tensorflow.op.image.DrawBoundingBoxes;
import org.tensorflow.op.image.EncodeJpeg;
import org.tensorflow.op.image.EncodeJpegVariableQuality;
import org.tensorflow.op.image.EncodePng;
import org.tensorflow.op.image.ExtractGlimpse;
import org.tensorflow.op.image.ExtractImagePatches;
import org.tensorflow.op.image.ExtractJpegShape;
import org.tensorflow.op.image.HsvToRgb;
import org.tensorflow.op.image.NonMaxSuppression;
import org.tensorflow.op.image.NonMaxSuppressionWithOverlaps;
import org.tensorflow.op.image.QuantizedResizeBilinear;
import org.tensorflow.op.image.RandomCrop;
import org.tensorflow.op.image.ResizeArea;
import org.tensorflow.op.image.ResizeBicubic;
import org.tensorflow.op.image.ResizeBilinear;
import org.tensorflow.op.image.ResizeNearestNeighbor;
import org.tensorflow.op.image.RgbToHsv;
import org.tensorflow.op.image.SampleDistortedBoundingBox;
import org.tensorflow.types.UInt8;

public final class ImageOps {
    private final Scope scope;

    ImageOps(Scope scope) {
        this.scope = scope;
    }

    public ExtractJpegShape<Integer> extractJpegShape(Operand<String> contents) {
        return ExtractJpegShape.create(this.scope, contents);
    }

    public <T extends Number> CropAndResizeGradBoxes cropAndResizeGradBoxes(Operand<Float> grads, Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd, CropAndResizeGradBoxes.Options ... options) {
        return CropAndResizeGradBoxes.create(this.scope, grads, image, boxes, boxInd, options);
    }

    public DecodeBmp decodeBmp(Operand<String> contents, DecodeBmp.Options ... options) {
        return DecodeBmp.create(this.scope, contents, options);
    }

    public <T extends Number> RandomCrop<T> randomCrop(Operand<T> image, Operand<Long> size, RandomCrop.Options ... options) {
        return RandomCrop.create(this.scope, image, size, options);
    }

    public DecodeJpeg decodeJpeg(Operand<String> contents, DecodeJpeg.Options ... options) {
        return DecodeJpeg.create(this.scope, contents, options);
    }

    public <T extends Number> ResizeNearestNeighbor<T> resizeNearestNeighbor(Operand<T> images, Operand<Integer> size, ResizeNearestNeighbor.Options ... options) {
        return ResizeNearestNeighbor.create(this.scope, images, size, options);
    }

    public <T extends Number> HsvToRgb<T> hsvToRgb(Operand<T> images) {
        return HsvToRgb.create(this.scope, images);
    }

    public ExtractGlimpse extractGlimpse(Operand<Float> input, Operand<Integer> size, Operand<Float> offsets, ExtractGlimpse.Options ... options) {
        return ExtractGlimpse.create(this.scope, input, size, offsets, options);
    }

    public <T extends Number> ResizeBilinear resizeBilinear(Operand<T> images, Operand<Integer> size, ResizeBilinear.Options ... options) {
        return ResizeBilinear.create(this.scope, images, size, options);
    }

    public EncodeJpegVariableQuality encodeJpegVariableQuality(Operand<UInt8> images, Operand<Integer> quality) {
        return EncodeJpegVariableQuality.create(this.scope, images, quality);
    }

    public <T extends Number> ResizeBicubic resizeBicubic(Operand<T> images, Operand<Integer> size, ResizeBicubic.Options ... options) {
        return ResizeBicubic.create(this.scope, images, size, options);
    }

    public DecodeGif decodeGif(Operand<String> contents) {
        return DecodeGif.create(this.scope, contents);
    }

    public <T extends Number> EncodePng encodePng(Operand<T> image, EncodePng.Options ... options) {
        return EncodePng.create(this.scope, image, options);
    }

    public <T extends Number> AdjustContrast<T> adjustContrast(Operand<T> images, Operand<Float> contrastFactor) {
        return AdjustContrast.create(this.scope, images, contrastFactor);
    }

    public <T extends Number> CropAndResizeGradImage<T> cropAndResizeGradImage(Operand<Float> grads, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> imageSize, Class<T> T, CropAndResizeGradImage.Options ... options) {
        return CropAndResizeGradImage.create(this.scope, grads, boxes, boxInd, imageSize, T, options);
    }

    public <T extends Number> ExtractJpegShape<T> extractJpegShape(Operand<String> contents, Class<T> outputType) {
        return ExtractJpegShape.create(this.scope, contents, outputType);
    }

    public DecodePng<UInt8> decodePng(Operand<String> contents, DecodePng.Options ... options) {
        return DecodePng.create(this.scope, contents, options);
    }

    public <T extends Number> CropAndResize cropAndResize(Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> cropSize, CropAndResize.Options ... options) {
        return CropAndResize.create(this.scope, image, boxes, boxInd, cropSize, options);
    }

    public <T extends Number> AdjustSaturation<T> adjustSaturation(Operand<T> images, Operand<Float> scale) {
        return AdjustSaturation.create(this.scope, images, scale);
    }

    public EncodeJpeg encodeJpeg(Operand<UInt8> image, EncodeJpeg.Options ... options) {
        return EncodeJpeg.create(this.scope, image, options);
    }

    public <T> QuantizedResizeBilinear<T> quantizedResizeBilinear(Operand<T> images, Operand<Integer> size, Operand<Float> min, Operand<Float> max, QuantizedResizeBilinear.Options ... options) {
        return QuantizedResizeBilinear.create(this.scope, images, size, min, max, options);
    }

    public NonMaxSuppressionWithOverlaps nonMaxSuppressionWithOverlaps(Operand<Float> overlaps, Operand<Float> scores, Operand<Integer> maxOutputSize, Operand<Float> overlapThreshold, Operand<Float> scoreThreshold) {
        return NonMaxSuppressionWithOverlaps.create(this.scope, overlaps, scores, maxOutputSize, overlapThreshold, scoreThreshold);
    }

    public <T extends Number> SampleDistortedBoundingBox<T> sampleDistortedBoundingBox(Operand<T> imageSize, Operand<Float> boundingBoxes, Operand<Float> minObjectCovered, SampleDistortedBoundingBox.Options ... options) {
        return SampleDistortedBoundingBox.create(this.scope, imageSize, boundingBoxes, minObjectCovered, options);
    }

    public <T extends Number> NonMaxSuppression nonMaxSuppression(Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold, NonMaxSuppression.Options ... options) {
        return NonMaxSuppression.create(this.scope, boxes, scores, maxOutputSize, iouThreshold, scoreThreshold, options);
    }

    public <T extends Number> ExtractImagePatches<T> extractImagePatches(Operand<T> images, List<Long> ksizes, List<Long> strides, List<Long> rates, String padding) {
        return ExtractImagePatches.create(this.scope, images, ksizes, strides, rates, padding);
    }

    public <T extends Number> ResizeArea resizeArea(Operand<T> images, Operand<Integer> size, ResizeArea.Options ... options) {
        return ResizeArea.create(this.scope, images, size, options);
    }

    public <T extends Number> DecodePng<T> decodePng(Operand<String> contents, Class<T> dtype, DecodePng.Options ... options) {
        return DecodePng.create(this.scope, contents, dtype, options);
    }

    public <T extends Number> RgbToHsv<T> rgbToHsv(Operand<T> images) {
        return RgbToHsv.create(this.scope, images);
    }

    public DecodeAndCropJpeg decodeAndCropJpeg(Operand<String> contents, Operand<Integer> cropWindow, DecodeAndCropJpeg.Options ... options) {
        return DecodeAndCropJpeg.create(this.scope, contents, cropWindow, options);
    }

    public <T extends Number> AdjustHue<T> adjustHue(Operand<T> images, Operand<Float> delta) {
        return AdjustHue.create(this.scope, images, delta);
    }

    public <T extends Number> DrawBoundingBoxes<T> drawBoundingBoxes(Operand<T> images, Operand<Float> boxes) {
        return DrawBoundingBoxes.create(this.scope, images, boxes);
    }
}

