/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X>
extends PrimitiveOp {
    private Output<X> output;
    private Output<Float> minOutput;
    private Output<Float> maxOutput;

    public static <X, T, U, V, W> QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X> create(Scope scope, Operand<T> input, Operand<U> filter, Operand<V> bias, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minFilter, Operand<Float> maxFilter, Operand<Float> minFreezedOutput, Operand<Float> maxFreezedOutput, Operand<W> summand, Operand<Float> minSummand, Operand<Float> maxSummand, Class<X> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedConv2DWithBiasSignedSumAndReluAndRequantize", scope.makeOpName("QuantizedConv2DWithBiasSignedSumAndReluAndRequantize"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minFilter.asOutput());
        opBuilder.addInput(maxFilter.asOutput());
        opBuilder.addInput(minFreezedOutput.asOutput());
        opBuilder.addInput(maxFreezedOutput.asOutput());
        opBuilder.addInput(summand.asOutput());
        opBuilder.addInput(minSummand.asOutput());
        opBuilder.addInput(maxSummand.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.dilations != null) {
                    long[] dilationsArray = new long[opts.dilations.size()];
                    for (i = 0; i < dilationsArray.length; ++i) {
                        dilationsArray[i] = (Long)opts.dilations.get(i);
                    }
                    opBuilder.setAttr("dilations", dilationsArray);
                }
                if (opts.paddingList == null) continue;
                long[] paddingListArray = new long[opts.paddingList.size()];
                for (i = 0; i < paddingListArray.length; ++i) {
                    paddingListArray[i] = (Long)opts.paddingList.get(i);
                }
                opBuilder.setAttr("padding_list", paddingListArray);
            }
        }
        return new QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X>(opBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options paddingList(List<Long> paddingList) {
        return new Options().paddingList(paddingList);
    }

    public Output<X> output() {
        return this.output;
    }

    public Output<Float> minOutput() {
        return this.minOutput;
    }

    public Output<Float> maxOutput() {
        return this.maxOutput;
    }

    private QuantizedConv2DWithBiasSignedSumAndReluAndRequantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> dilations;
        private List<Long> paddingList;

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options paddingList(List<Long> paddingList) {
            this.paddingList = paddingList;
            return this;
        }

        private Options() {
        }
    }
}

