/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedDepthwiseConv2DWithBias<V>
extends PrimitiveOp {
    private Output<V> output;
    private Output<Float> minOutput;
    private Output<Float> maxOutput;

    public static <V, T, U> QuantizedDepthwiseConv2DWithBias<V> create(Scope scope, Operand<T> input, Operand<U> filter, Operand<Float> bias, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minFilter, Operand<Float> maxFilter, Class<V> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedDepthwiseConv2DWithBias", scope.makeOpName("QuantizedDepthwiseConv2DWithBias"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minFilter.asOutput());
        opBuilder.addInput(maxFilter.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = (Long)opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new QuantizedDepthwiseConv2DWithBias<V>(opBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<Float> minOutput() {
        return this.minOutput;
    }

    public Output<Float> maxOutput() {
        return this.maxOutput;
    }

    private QuantizedDepthwiseConv2DWithBias(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> dilations;

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

