/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RemoteFusedGraphExecute
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> outputs;

    public static RemoteFusedGraphExecute create(Scope scope, Iterable<Operand<?>> inputs, List<Class<?>> Toutputs, String serializedRemoteFusedGraphExecuteInfo) {
        OperationBuilder opBuilder = scope.env().opBuilder("RemoteFusedGraphExecute", scope.makeOpName("RemoteFusedGraphExecute"));
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] ToutputsArray = new DataType[Toutputs.size()];
        for (int i = 0; i < ToutputsArray.length; ++i) {
            ToutputsArray[i] = DataType.fromClass(Toutputs.get(i));
        }
        opBuilder.setAttr("Toutputs", ToutputsArray);
        opBuilder.setAttr("serialized_remote_fused_graph_execute_info", serializedRemoteFusedGraphExecuteInfo);
        return new RemoteFusedGraphExecute(opBuilder.build());
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<Object>> iterator() {
        return this.outputs.iterator();
    }

    private RemoteFusedGraphExecute(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }
}

