/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ShardDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ShardDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> numShards, Operand<Long> index, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ShardDataset", scope.makeOpName("ShardDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numShards.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.requireNonEmpty == null) continue;
                opBuilder.setAttr("require_non_empty", opts.requireNonEmpty);
            }
        }
        return new ShardDataset(opBuilder.build());
    }

    public static Options requireNonEmpty(Boolean requireNonEmpty) {
        return new Options().requireNonEmpty(requireNonEmpty);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ShardDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean requireNonEmpty;

        public Options requireNonEmpty(Boolean requireNonEmpty) {
            this.requireNonEmpty = requireNonEmpty;
            return this;
        }

        private Options() {
        }
    }
}

