/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeNearestNeighborGrad<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> ResizeNearestNeighborGrad<T> create(Scope scope, Operand<T> grads, Operand<Integer> size, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ResizeNearestNeighborGrad", scope.makeOpName("ResizeNearestNeighborGrad"));
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners != null) {
                    opBuilder.setAttr("align_corners", opts.alignCorners);
                }
                if (opts.halfPixelCenters == null) continue;
                opBuilder.setAttr("half_pixel_centers", opts.halfPixelCenters);
            }
        }
        return new ResizeNearestNeighborGrad<T>(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public static Options halfPixelCenters(Boolean halfPixelCenters) {
        return new Options().halfPixelCenters(halfPixelCenters);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private ResizeNearestNeighborGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;
        private Boolean halfPixelCenters;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        public Options halfPixelCenters(Boolean halfPixelCenters) {
            this.halfPixelCenters = halfPixelCenters;
            return this;
        }

        private Options() {
        }
    }
}

