/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchMatrixSolve<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> BatchMatrixSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BatchMatrixSolve", scope.makeOpName("BatchMatrixSolve"));
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new BatchMatrixSolve<T>(opBuilder.build());
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private BatchMatrixSolve(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean adjoint;

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }

        private Options() {
        }
    }
}

