/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FractionalMaxPool<T extends Number>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Long> rowPoolingSequence;
    private Output<Long> colPoolingSequence;

    public static <T extends Number> FractionalMaxPool<T> create(Scope scope, Operand<T> value, List<Float> poolingRatio, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("FractionalMaxPool", scope.makeOpName("FractionalMaxPool"));
        opBuilder.addInput(value.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        float[] poolingRatioArray = new float[poolingRatio.size()];
        for (int i = 0; i < poolingRatioArray.length; ++i) {
            poolingRatioArray[i] = poolingRatio.get(i).floatValue();
        }
        opBuilder.setAttr("pooling_ratio", poolingRatioArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.pseudoRandom != null) {
                    opBuilder.setAttr("pseudo_random", opts.pseudoRandom);
                }
                if (opts.overlapping != null) {
                    opBuilder.setAttr("overlapping", opts.overlapping);
                }
                if (opts.deterministic != null) {
                    opBuilder.setAttr("deterministic", opts.deterministic);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new FractionalMaxPool<T>(opBuilder.build());
    }

    public static Options pseudoRandom(Boolean pseudoRandom) {
        return new Options().pseudoRandom(pseudoRandom);
    }

    public static Options overlapping(Boolean overlapping) {
        return new Options().overlapping(overlapping);
    }

    public static Options deterministic(Boolean deterministic) {
        return new Options().deterministic(deterministic);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<Long> rowPoolingSequence() {
        return this.rowPoolingSequence;
    }

    public Output<Long> colPoolingSequence() {
        return this.colPoolingSequence;
    }

    private FractionalMaxPool(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.rowPoolingSequence = operation.output(outputIdx++);
        this.colPoolingSequence = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean pseudoRandom;
        private Boolean overlapping;
        private Boolean deterministic;
        private Long seed;
        private Long seed2;

        public Options pseudoRandom(Boolean pseudoRandom) {
            this.pseudoRandom = pseudoRandom;
            return this;
        }

        public Options overlapping(Boolean overlapping) {
            this.overlapping = overlapping;
            return this;
        }

        public Options deterministic(Boolean deterministic) {
            this.deterministic = deterministic;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

