/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseMatMul
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> product;

    public static <T extends Number, U extends Number> SparseMatMul create(Scope scope, Operand<T> a, Operand<U> b, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseMatMul", scope.makeOpName("SparseMatMul"));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.aIsSparse != null) {
                    opBuilder.setAttr("a_is_sparse", opts.aIsSparse);
                }
                if (opts.bIsSparse == null) continue;
                opBuilder.setAttr("b_is_sparse", opts.bIsSparse);
            }
        }
        return new SparseMatMul(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options aIsSparse(Boolean aIsSparse) {
        return new Options().aIsSparse(aIsSparse);
    }

    public static Options bIsSparse(Boolean bIsSparse) {
        return new Options().bIsSparse(bIsSparse);
    }

    public Output<Float> product() {
        return this.product;
    }

    @Override
    public Output<Float> asOutput() {
        return this.product;
    }

    private SparseMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean aIsSparse;
        private Boolean bIsSparse;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options aIsSparse(Boolean aIsSparse) {
            this.aIsSparse = aIsSparse;
            return this;
        }

        public Options bIsSparse(Boolean bIsSparse) {
            this.bIsSparse = bIsSparse;
            return this;
        }

        private Options() {
        }
    }
}

