/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseTensorDenseMatMul<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> product;

    public static <U, T extends Number> SparseTensorDenseMatMul<U> create(Scope scope, Operand<T> aIndices, Operand<U> aValues, Operand<Long> aShape, Operand<U> b, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseTensorDenseMatMul", scope.makeOpName("SparseTensorDenseMatMul"));
        opBuilder.addInput(aIndices.asOutput());
        opBuilder.addInput(aValues.asOutput());
        opBuilder.addInput(aShape.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjointA != null) {
                    opBuilder.setAttr("adjoint_a", opts.adjointA);
                }
                if (opts.adjointB == null) continue;
                opBuilder.setAttr("adjoint_b", opts.adjointB);
            }
        }
        return new SparseTensorDenseMatMul<U>(opBuilder.build());
    }

    public static Options adjointA(Boolean adjointA) {
        return new Options().adjointA(adjointA);
    }

    public static Options adjointB(Boolean adjointB) {
        return new Options().adjointB(adjointB);
    }

    public Output<U> product() {
        return this.product;
    }

    @Override
    public Output<U> asOutput() {
        return this.product;
    }

    private SparseTensorDenseMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean adjointA;
        private Boolean adjointB;

        public Options adjointA(Boolean adjointA) {
            this.adjointA = adjointA;
            return this;
        }

        public Options adjointB(Boolean adjointB) {
            this.adjointB = adjointB;
            return this;
        }

        private Options() {
        }
    }
}

