/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Restore
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> tensors;

    public static Restore create(Scope scope, Operand<String> prefix, Operand<String> tensorNames, Operand<String> shapeAndSlices, List<Class<?>> dtypes) {
        OperationBuilder opBuilder = scope.env().opBuilder("RestoreV2", scope.makeOpName("Restore"));
        opBuilder.addInput(prefix.asOutput());
        opBuilder.addInput(tensorNames.asOutput());
        opBuilder.addInput(shapeAndSlices.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] dtypesArray = new DataType[dtypes.size()];
        for (int i = 0; i < dtypesArray.length; ++i) {
            dtypesArray[i] = DataType.fromClass(dtypes.get(i));
        }
        opBuilder.setAttr("dtypes", dtypesArray);
        return new Restore(opBuilder.build());
    }

    public List<Output<?>> tensors() {
        return this.tensors;
    }

    @Override
    public Iterator<Operand<Object>> iterator() {
        return this.tensors.iterator();
    }

    private Restore(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int tensorsLength = operation.outputListLength("tensors");
        this.tensors = Arrays.asList(operation.outputList(outputIdx, tensorsLength));
        outputIdx += tensorsLength;
    }
}

