/*
 * Decompiled with CFR 0.152.
 */
package g_objenesis.org.objenesis.strategy;

import g_objenesis.org.objenesis.ObjenesisException;
import g_objenesis.org.objenesis.instantiator.ObjectInstantiator;
import g_objenesis.org.objenesis.instantiator.android.AndroidSerializationInstantiator;
import g_objenesis.org.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import g_objenesis.org.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import g_objenesis.org.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import g_objenesis.org.objenesis.instantiator.perc.PercSerializationInstantiator;
import g_objenesis.org.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import g_objenesis.org.objenesis.strategy.BaseInstantiatorStrategy;
import g_objenesis.org.objenesis.strategy.PlatformDescription;
import java.io.NotSerializableException;
import java.io.Serializable;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            return new SunReflectionFactorySerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new SunReflectionFactorySerializationInstantiator<T>(type);
    }
}

