/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;

public class ExecutableMojo
extends AbstractMojo {
    private MavenProject m_project;
    private File m_work;
    private File m_warFile;
    private File m_jarFile;
    private MavenProjectHelper m_projectHelper;
    private String mainClass;

    void copyBootstrapClasses(File work) throws IOException {
        this.copyClass(work, "/bootstrap/Bootstrap.class");
    }

    private void copyClass(File work, String name) throws IOException, FileNotFoundException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        File file = new File(work, name);
        file.getParentFile().mkdirs();
        Files.forIO().copy(in, (OutputStream)new FileOutputStream(file));
    }

    void copyClassFile(File work, String testClasses, String main) throws IOException, FileNotFoundException {
        String classFile = main.replace('.', '/') + ".class";
        Files.forDir().copyFile(new File(testClasses, classFile), new File(work, "WEB-INF/classes/" + classFile));
    }

    private void copyTestScopedDependencies(File work, List<String> compile, List<String> runtime, List<String> test) throws IOException {
        for (String e : test) {
            if (compile.contains(e) || runtime.contains(e) || !e.endsWith(".jar")) continue;
            File jar = new File(e);
            Files.forDir().copyFile(jar, new File(work, "WEB-INF/ext/" + jar.getName()));
            this.getLog().debug((CharSequence)("copying " + jar.getName() + "to WEB-INF/ext"));
        }
    }

    String detectTestClass(File testClasses, final String className) {
        final StringBuilder sb = new StringBuilder();
        Scanners.forDir().scanForOne(testClasses, (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (path.endsWith(className)) {
                    int pos = path.lastIndexOf(46);
                    sb.append(path.substring(0, pos).replace('/', '.'));
                }
                return Scanners.IMatcher.Direction.DOWN;
            }
        });
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Checking WAR file: " + this.m_warFile));
        if (!this.m_warFile.exists()) {
            throw new MojoExecutionException("Not found, please run 'mvn package' first!");
        }
        this.getLog().info((CharSequence)("Working dir is " + this.m_work));
        this.m_work.mkdirs();
        try {
            this.getLog().info((CharSequence)"Extract WAR ...");
            this.extractWar(this.m_work, this.m_warFile);
            this.getLog().info((CharSequence)"Copy bootstrap classes ...");
            this.copyBootstrapClasses(this.m_work);
            this.getLog().info((CharSequence)"Revise MANIFEST.MF ...");
            this.reviseManifest(this.m_work);
            List test = this.m_project.getTestClasspathElements();
            List compile = this.m_project.getCompileClasspathElements();
            List runtime = this.m_project.getRuntimeClasspathElements();
            this.getLog().info((CharSequence)"Copy test scope dependencies to /WEB-INF/ext ...");
            this.copyTestScopedDependencies(this.m_work, compile, runtime, test);
            this.getLog().info((CharSequence)("Package into jar: " + this.m_jarFile));
            this.packageIntoJar(this.m_work, this.m_jarFile);
            this.m_projectHelper.attachArtifact(this.m_project, "jar", this.m_jarFile);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error when making executable jar from war!", e);
        }
    }

    void extractWar(File target, File warFile) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(warFile));
        Files.forZip().copyDir(zis, target);
        zis.close();
    }

    void packageIntoJar(File work, File jarFile) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(jarFile));
        Scanners.forDir().scan(work, (Scanners.IMatcher)new Scanners.IMatcher<File>(){

            public boolean isDirEligible() {
                return true;
            }

            public boolean isFileElegible() {
                return true;
            }

            public Scanners.IMatcher.Direction matches(File base, String path) {
                ZipEntry entry = new ZipEntry(path);
                try {
                    File file = new File(base, path);
                    if (file.isFile()) {
                        byte[] data = Files.forIO().readFrom(file);
                        entry.setSize(data.length);
                        entry.setTime(file.lastModified());
                        zos.putNextEntry(entry);
                        zos.write(data);
                    }
                }
                catch (IOException e) {
                    ExecutableMojo.this.getLog().warn((CharSequence)e.getMessage());
                }
                return Scanners.IMatcher.Direction.DOWN;
            }
        });
        zos.closeEntry();
        zos.close();
    }

    void reviseManifest(File work) throws IOException {
        File file = new File(work, "META-INF/MANIFEST.MF");
        FileInputStream in = new FileInputStream(file);
        Manifest manifest = new Manifest(in);
        ((InputStream)in).close();
        Attributes a = manifest.getMainAttributes();
        String main = this.mainClass;
        if (main == null) {
            main = a.getValue("Main-Class");
        }
        if (main == null) {
            String testClasses = this.m_project.getBuild().getTestOutputDirectory();
            main = this.detectTestClass(new File(testClasses), "/TestServer.class");
        }
        if (main == null) {
            throw new IllegalStateException("TestServer is not found!");
        }
        this.getLog().info((CharSequence)("Main class is " + main));
        a.putValue("Main-Class", "bootstrap.Bootstrap");
        a.putValue("X-Main-Class", main);
        this.copyClassFile(work, this.m_project.getBuild().getTestOutputDirectory(), main);
        FileOutputStream out = new FileOutputStream(file);
        manifest.write(out);
        out.close();
    }
}

