/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.maven.plugin.common.AbstractMojoWithDependency;

public class WebModuleMojo
extends AbstractMojoWithDependency {
    protected MavenProject m_project;
    protected boolean verbose;
    protected boolean debug;
    protected boolean skip;

    private void copyDirWithoutOverwrite(File source, File base, AtomicInteger count) throws IOException {
        if (source.isDirectory()) {
            final ArrayList paths = new ArrayList();
            Scanners.forDir().scan(source, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (path.startsWith("/WEB-MODULE/")) {
                        paths.add(path);
                    }
                    return Scanners.IMatcher.Direction.DOWN;
                }
            });
            for (String path : paths) {
                File from = new File(source, path);
                File to = new File(base, path);
                if (to.exists()) continue;
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Copy " + to));
                }
                count.incrementAndGet();
                Files.forDir().copyFile(from, to);
            }
        } else if (source.getPath().endsWith(".jar")) {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(source));
            while ((entry = zis.getNextEntry()) != null) {
                File to;
                String path = entry.getName();
                if (!path.startsWith("WEB-MODULE/") || path.endsWith("/") || (to = new File(base, path.substring("WEB-MODULE/".length()))).exists()) continue;
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Copy " + to));
                }
                to.getParentFile().mkdirs();
                Files.IO.INSTANCE.copy((InputStream)zis, (OutputStream)new FileOutputStream(to), Files.AutoClose.OUTPUT);
                count.incrementAndGet();
            }
            zis.close();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"The plugin was skipped explicitly.");
            return;
        }
        if (this.debug) {
            this.verbose = true;
        }
        try {
            this.resolveRuntimeDependencies();
            Build build = this.m_project.getBuild();
            File base = new File(build.getDirectory(), build.getFinalName());
            if (this.verbose) {
                this.getLog().info((CharSequence)("Target dir: " + base.getCanonicalFile()));
            }
            AtomicInteger count = new AtomicInteger();
            for (Artifact artifact : this.m_project.getArtifacts()) {
                this.copyDirWithoutOverwrite(artifact.getFile(), base, count);
            }
            this.getLog().info((CharSequence)(count.get() + " files copied."));
        }
        catch (Exception e) {
            throw new MojoFailureException("Error when resolving project dependencies!2", (Throwable)e);
        }
    }
}

