/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.webbitserver.helpers.UTF8Exception;
import org.webbitserver.helpers.UTF8Output;
import org.webbitserver.netty.DecodingHybiFrame;
import org.webbitserver.netty.EncodingHybiFrame;

public class HybiWebSocketFrameDecoder
extends ReplayingDecoder<State> {
    private final UTF8Output utf8Output = new UTF8Output();
    private final boolean isServer;
    private final boolean requireMaskedInboundFrames;
    private final byte[] outboundMaskingKey;
    private boolean frameFin;
    private int frameOpcode;
    private long framePayloadLen;
    private byte[] inboundMaskingKey;
    private DecodingHybiFrame currentFrame;

    public static HybiWebSocketFrameDecoder serverSide() {
        return new HybiWebSocketFrameDecoder(true, null);
    }

    public static HybiWebSocketFrameDecoder clientSide(byte[] outboundMaskingKey) {
        return new HybiWebSocketFrameDecoder(false, outboundMaskingKey);
    }

    private HybiWebSocketFrameDecoder(boolean isServer, byte[] outboundMaskingKey) {
        super((Enum)State.FRAME_START);
        this.isServer = isServer;
        this.requireMaskedInboundFrames = isServer;
        this.outboundMaskingKey = outboundMaskingKey;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case FRAME_START: {
                this.inboundMaskingKey = null;
                byte b = buffer.readByte();
                this.frameFin = (b & 0x80) != 0;
                int frameRsv = (b & 0x70) >> 4;
                this.frameOpcode = b & 0xF;
                b = buffer.readByte();
                boolean frameMasked = (b & 0x80) != 0;
                int framePayloadLen1 = b & 0x7F;
                if (frameRsv != 0) {
                    this.protocolViolation(channel, "RSV != 0 and no extension negotiated, RSV:" + frameRsv);
                    return null;
                }
                if (this.isServer && this.requireMaskedInboundFrames && !frameMasked) {
                    this.protocolViolation(channel, "Received unmasked frame");
                    return null;
                }
                if (this.frameOpcode > 7) {
                    if (!this.frameFin) {
                        this.protocolViolation(channel, "fragmented control frame");
                        return null;
                    }
                    if (framePayloadLen1 > 125) {
                        this.protocolViolation(channel, "control frame with payload length > 125 octets");
                        return null;
                    }
                    if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                        this.protocolViolation(channel, "control frame using reserved opcode " + this.frameOpcode);
                        return null;
                    }
                    if (this.frameOpcode == 8 && framePayloadLen1 == 1) {
                        this.protocolViolation(channel, "received close control frame with payload len 1");
                        return null;
                    }
                } else {
                    if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                        this.protocolViolation(channel, "data frame using reserved opcode " + this.frameOpcode);
                        return null;
                    }
                    if (this.currentFrame == null && this.frameOpcode == 0) {
                        this.protocolViolation(channel, "received continuation data frame outside fragmented message");
                        return null;
                    }
                    if (this.currentFrame != null && this.frameOpcode != 0) {
                        this.protocolViolation(channel, "received non-continuation data frame while inside fragmented message");
                        return null;
                    }
                }
                if (framePayloadLen1 == 126) {
                    this.framePayloadLen = buffer.readUnsignedShort();
                    if (this.framePayloadLen < 126L) {
                        this.protocolViolation(channel, "invalid data frame length (not using minimal length encoding)");
                        return null;
                    }
                } else if (framePayloadLen1 == 127) {
                    this.framePayloadLen = buffer.readLong();
                    if (this.framePayloadLen < 65536L) {
                        this.protocolViolation(channel, "invalid data frame length (not using minimal length encoding)");
                        return null;
                    }
                } else {
                    this.framePayloadLen = framePayloadLen1;
                }
                if (frameMasked) {
                    this.checkpoint(State.MASKING_KEY);
                } else {
                    this.checkpoint(State.PAYLOAD);
                    return null;
                }
            }
            case MASKING_KEY: {
                this.inboundMaskingKey = buffer.readBytes(4).array();
                this.checkpoint(State.PAYLOAD);
            }
            case PAYLOAD: {
                ChannelBuffer frame = buffer.readBytes(this.toFrameLength(this.framePayloadLen));
                if (this.inboundMaskingKey != null) {
                    HybiWebSocketFrameDecoder.applyMask(frame, this.inboundMaskingKey);
                }
                this.checkpoint(State.FRAME_START);
                if (this.frameOpcode == 8) {
                    EncodingHybiFrame close = new EncodingHybiFrame(8, true, 0, this.outboundMaskingKey, ChannelBuffers.buffer((int)0));
                    channel.write((Object)close);
                    channel.close();
                    return null;
                }
                if (this.frameOpcode == 0) {
                    try {
                        this.currentFrame.append(frame);
                    }
                    catch (UTF8Exception e) {
                        this.protocolViolation(channel, "invalid UTF-8 bytes");
                    }
                } else {
                    if (this.frameOpcode == 9 || this.frameOpcode == 10) {
                        return new DecodingHybiFrame(this.frameOpcode, this.utf8Output, frame);
                    }
                    try {
                        this.currentFrame = new DecodingHybiFrame(this.frameOpcode, this.utf8Output, frame);
                    }
                    catch (UTF8Exception e) {
                        this.protocolViolation(channel, "invalid UTF-8 bytes");
                    }
                }
                if (this.frameFin) {
                    DecodingHybiFrame result = this.currentFrame;
                    this.currentFrame = null;
                    return result;
                }
                return null;
            }
            case CORRUPT: {
                buffer.readByte();
                return null;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    static void applyMask(ChannelBuffer data, byte[] maskingKey) {
        int length = data.writerIndex();
        for (int i = 0; i < length; ++i) {
            data.setByte(i, data.getByte(i) ^ maskingKey[i % 4]);
        }
    }

    private void protocolViolation(Channel channel, String reason) throws CorruptedFrameException {
        this.checkpoint(State.CORRUPT);
        if (channel.isConnected()) {
            channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            channel.close().awaitUninterruptibly();
        }
        throw new CorruptedFrameException(reason);
    }

    private int toFrameLength(long l) throws TooLongFrameException {
        if (l > Integer.MAX_VALUE) {
            throw new TooLongFrameException("Length:" + l);
        }
        return (int)l;
    }

    public static enum State {
        FRAME_START,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

