/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class InterpolationFilterReader
extends FilterReader {
    private String queuedData = null;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int queueIndex = -1;
    private Map variables = new HashMap();
    private String beginToken;
    private String endToken;
    private int beginTokenLength;
    private int endTokenLength;
    private static String DEFAULT_BEGIN_TOKEN = "${";
    private static String DEFAULT_END_TOKEN = "}";

    public InterpolationFilterReader(Reader in, Map variables, String beginToken, String endToken) {
        super(in);
        this.variables = variables;
        this.beginToken = beginToken;
        this.endToken = endToken;
        this.beginTokenLength = beginToken.length();
        this.endTokenLength = endToken.length();
    }

    public InterpolationFilterReader(Reader in, Map variables) {
        this(in, variables, DEFAULT_BEGIN_TOKEN, DEFAULT_END_TOKEN);
    }

    private int getNextChar() throws IOException {
        if (this.queueIndex != -1) {
            char ch = this.queuedData.charAt(this.queueIndex++);
            if (this.queueIndex >= this.queuedData.length()) {
                this.queueIndex = -1;
            }
            return ch;
        }
        return this.in.read();
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.replaceIndex != -1) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = this.getNextChar();
        if (ch == this.beginToken.charAt(0)) {
            StringBuffer key = new StringBuffer();
            while ((ch = this.getNextChar()) != -1) {
                key.append((char)ch);
                if (ch != this.endToken.charAt(0)) continue;
            }
            if (ch == -1) {
                return this.endToken.charAt(0);
            }
            String variableKey = key.substring(this.beginTokenLength - 1, key.length() - this.endTokenLength);
            String value = (String)this.variables.get(variableKey);
            if (value != null) {
                if (value.length() != 0) {
                    this.replaceData = value;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            String newData = key.toString();
            this.queuedData = this.queuedData == null || this.queueIndex == -1 ? newData : newData + this.queuedData.substring(this.queueIndex);
            this.queueIndex = 0;
            return this.beginToken.charAt(0);
        }
        return ch;
    }
}

