/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.qqt.exception.ParamErrorException;
import com.qqt.exception.TokenErrorException;
import com.qqt.vo.AbstractResultVO;
import com.qqt.vo.ResultFactory;
import java.io.IOException;
import java.util.List;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseController {
    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    protected AbstractResultVO handleParamErrorException(IllegalArgumentException ex) {
        return this.exceptionMessage(ex);
    }

    @ExceptionHandler(value={ParamErrorException.class})
    @ResponseBody
    protected AbstractResultVO handleParamErrorException(ParamErrorException ex) {
        return this.exceptionMessage(ex);
    }

    @ExceptionHandler(value={TokenErrorException.class})
    @ResponseBody
    protected AbstractResultVO handleTokenErrorException(TokenErrorException ex) {
        return this.exceptionMessage(ex);
    }

    @ExceptionHandler(value={JsonParseException.class})
    @ResponseBody
    protected AbstractResultVO handleJsonParseException(JsonParseException ex) {
        return this.exceptionMessage((Exception)ex);
    }

    @ExceptionHandler(value={JsonMappingException.class})
    @ResponseBody
    protected AbstractResultVO handleJsonMappingException(JsonMappingException ex) {
        return this.exceptionMessage((Exception)ex);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseBody
    protected AbstractResultVO handleIOException(IOException ex) {
        return this.exceptionMessage(ex);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    protected AbstractResultVO handleException(HttpMessageNotReadableException ex) {
        return this.exceptionMessage((Exception)ex);
    }

    private AbstractResultVO exceptionMessage(Exception ex) {
        AbstractResultVO vo = ResultFactory.createExceptionResult();
        vo.setMessage(ex.getMessage());
        return vo;
    }

    @Deprecated
    protected void checkQueryParam(List<String[]> queryProperties) {
        boolean flag = true;
        for (int i = 0; i < queryProperties.size(); ++i) {
            if (flag && queryProperties.get(i).length < 2) {
                throw new IllegalArgumentException("\u53c2\u5165\u53c2\u6570\u6709\u8bef.");
            }
            flag = false;
            String[] properties = queryProperties.get(i);
            if (properties.length == 1) {
                flag = true;
                if ("or".equals(properties[0]) && "and".equals(properties[0])) continue;
                throw new IllegalArgumentException("\u53c2\u5165\u53c2\u6570\u6709\u8bef.");
            }
            if (properties.length == 2 || properties.length == 3) continue;
            throw new IllegalArgumentException("\u53c2\u5165\u53c2\u6570\u6709\u8bef.");
        }
    }
}

