/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileUtil {
    public static void createFile(String filePath, byte[] fileContent) throws IOException {
        URI uri = URI.create("file:///" + filePath);
        Path path = Paths.get(uri);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        FileOutputStream fos = new FileOutputStream(path.toFile());
        FileChannel fileChannel = fos.getChannel();
        for (int i = 0; i < fileContent.length; ++i) {
            byteBuffer.put(fileContent[i]);
            if (byteBuffer.capacity() != byteBuffer.position()) continue;
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            byteBuffer.clear();
        }
        if (byteBuffer.position() > 0) {
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            byteBuffer.clear();
        }
        fileChannel.close();
        fos.close();
    }

    public static boolean deleteByFileExtendName(File file, String extendFileName) {
        boolean result = true;
        if (file.isFile()) {
            if (file.getName().endsWith(extendFileName)) {
                result = file.delete();
            }
        } else if (file.getName().equals("test")) {
            result = FileUtil.deleteDirectory(file);
        } else {
            File[] files;
            for (File s : files = file.listFiles()) {
                result = FileUtil.deleteByFileExtendName(s, extendFileName);
            }
        }
        return result;
    }

    public static boolean deleteDojoHelpFile(File file) {
        boolean result = true;
        String lastFileName = "uncompressed.js";
        if (file.isFile()) {
            if (file.getName().endsWith("uncompressed.js")) {
                result = file.delete();
            }
        } else if (file.getName().equals("test") || file.getName().equals("tests") || file.getName().equals("demo") || file.getName().equals("demos") || file.getName().equals("doc") || file.getName().equals("docs")) {
            result = FileUtil.deleteDirectory(file);
        } else {
            File[] files;
            for (File s : files = file.listFiles()) {
                result = FileUtil.deleteDojoHelpFile(s);
            }
        }
        return result;
    }

    public static boolean deleteDirectory(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        File[] files = file.listFiles();
        boolean flag = true;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                files[i].delete();
                continue;
            }
            flag = FileUtil.deleteDirectory(files[i]);
            if (!flag) break;
        }
        if (!flag) {
            return false;
        }
        return file.delete();
    }
}

