/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JsonUtil {
    public static String writeValueAsString(Object object) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString(object);
    }

    public static <T> T convertValue(String fromValue, Class<T> toValueType) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(fromValue, toValueType);
    }

    public static <T> T convertCollection(String fromValue, Class<T> collectionClass, Class<?> subCollectionClass, Class<?> ... elementClasses) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JavaType javaType = objectMapper.getTypeFactory().constructParametrizedType(collectionClass, subCollectionClass, (Class[])elementClasses);
        return (T)objectMapper.readValue(fromValue, javaType);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> subCollectionClass, Class<?> ... elementClasses) {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.getTypeFactory().constructParametrizedType(collectionClass, subCollectionClass, (Class[])elementClasses);
    }
}

