/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class XmlUtil {
    public static <T> T convertToBean(Class<T> clazz, String xml) throws JsonParseException, JsonMappingException, IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz parameter is null.");
        }
        if (xml == null) {
            throw new NullPointerException("xml parameter is null.");
        }
        String clazzName = clazz.getSimpleName();
        String start = "<" + clazzName + ">";
        String end = "</" + clazzName + ">";
        if (!xml.startsWith(start) || !xml.endsWith(end)) {
            throw new IllegalArgumentException("xml string parameter must start with " + start + " and end with " + end);
        }
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object t = xmlMapper.readValue(xml, clazz);
        return (T)t;
    }

    public static <T> List<T> convertToListBean(Class<T> clazz, String xml) throws JsonParseException, JsonMappingException, IOException {
        String[] xmls;
        if (clazz == null) {
            throw new NullPointerException("clazz parameter is null.");
        }
        if (xml == null) {
            throw new NullPointerException("xml parameter is null.");
        }
        String clazzName = clazz.getSimpleName();
        String start = "<" + clazzName + ">";
        String end = "</" + clazzName + ">";
        int s1 = xml.indexOf(">");
        int e1 = xml.lastIndexOf("<");
        if (!(xml.startsWith("<item>") && xml.startsWith(start) || e1 <= s1)) {
            xml = xml.substring(s1 + 1, e1);
        }
        if ((xmls = (xml = xml.replace("<item>", "")).split("</item>")) == null || xmls.length < 1) {
            xml = xml.replace(start, "");
            xmls = xml.split(end);
        }
        if (xmls == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String x : xmls) {
            T t = XmlUtil.convertToBean(clazz, start + x + end);
            list.add(t);
        }
        return list;
    }
}

