/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfiguration> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::connectionArn)).setter(AuthenticationConfiguration.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRoleArn").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::accessRoleArn)).setter(AuthenticationConfiguration.setter(Builder::accessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionArn;
    private final String accessRoleArn;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.accessRoleArn = builder.accessRoleArn;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String accessRoleArn() {
        return this.accessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration)obj;
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.accessRoleArn(), other.accessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfiguration").add("ConnectionArn", (Object)this.connectionArn()).add("AccessRoleArn", (Object)this.accessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "AccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.accessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("AccessRoleArn", ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionArn;
        private String accessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            this.connectionArn(model.connectionArn);
            this.accessRoleArn(model.accessRoleArn);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getAccessRoleArn() {
            return this.accessRoleArn;
        }

        public final void setAccessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
        }

        @Override
        public final Builder accessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
            return this;
        }

        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfiguration> {
        public Builder connectionArn(String var1);

        public Builder accessRoleArn(String var1);
    }
}

