/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.CloudWatchLoggingConfiguration;
import software.amazon.awssdk.services.athena.model.ManagedLoggingConfiguration;
import software.amazon.awssdk.services.athena.model.S3LoggingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfiguration> {
    private static final SdkField<CloudWatchLoggingConfiguration> CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::cloudWatchLoggingConfiguration)).setter(MonitoringConfiguration.setter(Builder::cloudWatchLoggingConfiguration)).constructor(CloudWatchLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingConfiguration").build()}).build();
    private static final SdkField<ManagedLoggingConfiguration> MANAGED_LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedLoggingConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::managedLoggingConfiguration)).setter(MonitoringConfiguration.setter(Builder::managedLoggingConfiguration)).constructor(ManagedLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoggingConfiguration").build()}).build();
    private static final SdkField<S3LoggingConfiguration> S3_LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3LoggingConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::s3LoggingConfiguration)).setter(MonitoringConfiguration.setter(Builder::s3LoggingConfiguration)).constructor(S3LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LoggingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD, MANAGED_LOGGING_CONFIGURATION_FIELD, S3_LOGGING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;
    private final ManagedLoggingConfiguration managedLoggingConfiguration;
    private final S3LoggingConfiguration s3LoggingConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
        this.managedLoggingConfiguration = builder.managedLoggingConfiguration;
        this.s3LoggingConfiguration = builder.s3LoggingConfiguration;
    }

    public final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration() {
        return this.cloudWatchLoggingConfiguration;
    }

    public final ManagedLoggingConfiguration managedLoggingConfiguration() {
        return this.managedLoggingConfiguration;
    }

    public final S3LoggingConfiguration s3LoggingConfiguration() {
        return this.s3LoggingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LoggingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration)obj;
        return Objects.equals(this.cloudWatchLoggingConfiguration(), other.cloudWatchLoggingConfiguration()) && Objects.equals(this.managedLoggingConfiguration(), other.managedLoggingConfiguration()) && Objects.equals(this.s3LoggingConfiguration(), other.s3LoggingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfiguration").add("CloudWatchLoggingConfiguration", (Object)this.cloudWatchLoggingConfiguration()).add("ManagedLoggingConfiguration", (Object)this.managedLoggingConfiguration()).add("S3LoggingConfiguration", (Object)this.s3LoggingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingConfiguration()));
            }
            case "ManagedLoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.managedLoggingConfiguration()));
            }
            case "S3LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3LoggingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CloudWatchLoggingConfiguration", CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD);
        map.put("ManagedLoggingConfiguration", MANAGED_LOGGING_CONFIGURATION_FIELD);
        map.put("S3LoggingConfiguration", S3_LOGGING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;
        private ManagedLoggingConfiguration managedLoggingConfiguration;
        private S3LoggingConfiguration s3LoggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            this.cloudWatchLoggingConfiguration(model.cloudWatchLoggingConfiguration);
            this.managedLoggingConfiguration(model.managedLoggingConfiguration);
            this.s3LoggingConfiguration(model.s3LoggingConfiguration);
        }

        public final CloudWatchLoggingConfiguration.Builder getCloudWatchLoggingConfiguration() {
            return this.cloudWatchLoggingConfiguration != null ? this.cloudWatchLoggingConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration.BuilderImpl cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
            return this;
        }

        public final ManagedLoggingConfiguration.Builder getManagedLoggingConfiguration() {
            return this.managedLoggingConfiguration != null ? this.managedLoggingConfiguration.toBuilder() : null;
        }

        public final void setManagedLoggingConfiguration(ManagedLoggingConfiguration.BuilderImpl managedLoggingConfiguration) {
            this.managedLoggingConfiguration = managedLoggingConfiguration != null ? managedLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder managedLoggingConfiguration(ManagedLoggingConfiguration managedLoggingConfiguration) {
            this.managedLoggingConfiguration = managedLoggingConfiguration;
            return this;
        }

        public final S3LoggingConfiguration.Builder getS3LoggingConfiguration() {
            return this.s3LoggingConfiguration != null ? this.s3LoggingConfiguration.toBuilder() : null;
        }

        public final void setS3LoggingConfiguration(S3LoggingConfiguration.BuilderImpl s3LoggingConfiguration) {
            this.s3LoggingConfiguration = s3LoggingConfiguration != null ? s3LoggingConfiguration.build() : null;
        }

        @Override
        public final Builder s3LoggingConfiguration(S3LoggingConfiguration s3LoggingConfiguration) {
            this.s3LoggingConfiguration = s3LoggingConfiguration;
            return this;
        }

        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfiguration> {
        public Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration var1);

        default public Builder cloudWatchLoggingConfiguration(Consumer<CloudWatchLoggingConfiguration.Builder> cloudWatchLoggingConfiguration) {
            return this.cloudWatchLoggingConfiguration((CloudWatchLoggingConfiguration)((CloudWatchLoggingConfiguration.Builder)CloudWatchLoggingConfiguration.builder().applyMutation(cloudWatchLoggingConfiguration)).build());
        }

        public Builder managedLoggingConfiguration(ManagedLoggingConfiguration var1);

        default public Builder managedLoggingConfiguration(Consumer<ManagedLoggingConfiguration.Builder> managedLoggingConfiguration) {
            return this.managedLoggingConfiguration((ManagedLoggingConfiguration)((ManagedLoggingConfiguration.Builder)ManagedLoggingConfiguration.builder().applyMutation(managedLoggingConfiguration)).build());
        }

        public Builder s3LoggingConfiguration(S3LoggingConfiguration var1);

        default public Builder s3LoggingConfiguration(Consumer<S3LoggingConfiguration.Builder> s3LoggingConfiguration) {
            return this.s3LoggingConfiguration((S3LoggingConfiguration)((S3LoggingConfiguration.Builder)S3LoggingConfiguration.builder().applyMutation(s3LoggingConfiguration)).build());
        }
    }
}

