/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamedQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamedQuery> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NamedQuery.getter(NamedQuery::name)).setter(NamedQuery.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NamedQuery.getter(NamedQuery::description)).setter(NamedQuery.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(NamedQuery.getter(NamedQuery::database)).setter(NamedQuery.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(NamedQuery.getter(NamedQuery::queryString)).setter(NamedQuery.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamedQueryId").getter(NamedQuery.getter(NamedQuery::namedQueryId)).setter(NamedQuery.setter(Builder::namedQueryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(NamedQuery.getter(NamedQuery::workGroup)).setter(NamedQuery.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DATABASE_FIELD, QUERY_STRING_FIELD, NAMED_QUERY_ID_FIELD, WORK_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NamedQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String database;
    private final String queryString;
    private final String namedQueryId;
    private final String workGroup;

    private NamedQuery(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.namedQueryId = builder.namedQueryId;
        this.workGroup = builder.workGroup;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String database() {
        return this.database;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String namedQueryId() {
        return this.namedQueryId;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namedQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedQuery)) {
            return false;
        }
        NamedQuery other = (NamedQuery)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.namedQueryId(), other.namedQueryId()) && Objects.equals(this.workGroup(), other.workGroup());
    }

    public final String toString() {
        return ToString.builder((String)"NamedQuery").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Database", (Object)this.database()).add("QueryString", (Object)this.queryString()).add("NamedQueryId", (Object)this.namedQueryId()).add("WorkGroup", (Object)this.workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "NamedQueryId": {
                return Optional.ofNullable(clazz.cast(this.namedQueryId()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("NamedQueryId", NAMED_QUERY_ID_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamedQuery, T> g) {
        return obj -> g.apply((NamedQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String database;
        private String queryString;
        private String namedQueryId;
        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(NamedQuery model) {
            this.name(model.name);
            this.description(model.description);
            this.database(model.database);
            this.queryString(model.queryString);
            this.namedQueryId(model.namedQueryId);
            this.workGroup(model.workGroup);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getNamedQueryId() {
            return this.namedQueryId;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public NamedQuery build() {
            return new NamedQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamedQuery> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder database(String var1);

        public Builder queryString(String var1);

        public Builder namedQueryId(String var1);

        public Builder workGroup(String var1);
    }
}

