/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.EngineConfiguration;
import software.amazon.awssdk.services.athena.model.MonitoringConfiguration;
import software.amazon.awssdk.services.athena.model.Tag;
import software.amazon.awssdk.services.athena.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSessionRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, StartSessionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartSessionRequest.getter(StartSessionRequest::description)).setter(StartSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(StartSessionRequest.getter(StartSessionRequest::workGroup)).setter(StartSessionRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<EngineConfiguration> ENGINE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineConfiguration").getter(StartSessionRequest.getter(StartSessionRequest::engineConfiguration)).setter(StartSessionRequest.setter(Builder::engineConfiguration)).constructor(EngineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineConfiguration").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(StartSessionRequest.getter(StartSessionRequest::executionRole)).setter(StartSessionRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringConfiguration").getter(StartSessionRequest.getter(StartSessionRequest::monitoringConfiguration)).setter(StartSessionRequest.setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build()}).build();
    private static final SdkField<String> NOTEBOOK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookVersion").getter(StartSessionRequest.getter(StartSessionRequest::notebookVersion)).setter(StartSessionRequest.setter(Builder::notebookVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookVersion").build()}).build();
    private static final SdkField<Integer> SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionIdleTimeoutInMinutes").getter(StartSessionRequest.getter(StartSessionRequest::sessionIdleTimeoutInMinutes)).setter(StartSessionRequest.setter(Builder::sessionIdleTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionIdleTimeoutInMinutes").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartSessionRequest.getter(StartSessionRequest::clientRequestToken)).setter(StartSessionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartSessionRequest.getter(StartSessionRequest::tags)).setter(StartSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COPY_WORK_GROUP_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyWorkGroupTags").getter(StartSessionRequest.getter(StartSessionRequest::copyWorkGroupTags)).setter(StartSessionRequest.setter(Builder::copyWorkGroupTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyWorkGroupTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, WORK_GROUP_FIELD, ENGINE_CONFIGURATION_FIELD, EXECUTION_ROLE_FIELD, MONITORING_CONFIGURATION_FIELD, NOTEBOOK_VERSION_FIELD, SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, COPY_WORK_GROUP_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSessionRequest.memberNameToFieldInitializer();
    private final String description;
    private final String workGroup;
    private final EngineConfiguration engineConfiguration;
    private final String executionRole;
    private final MonitoringConfiguration monitoringConfiguration;
    private final String notebookVersion;
    private final Integer sessionIdleTimeoutInMinutes;
    private final String clientRequestToken;
    private final List<Tag> tags;
    private final Boolean copyWorkGroupTags;

    private StartSessionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.workGroup = builder.workGroup;
        this.engineConfiguration = builder.engineConfiguration;
        this.executionRole = builder.executionRole;
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.notebookVersion = builder.notebookVersion;
        this.sessionIdleTimeoutInMinutes = builder.sessionIdleTimeoutInMinutes;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.copyWorkGroupTags = builder.copyWorkGroupTags;
    }

    public final String description() {
        return this.description;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final EngineConfiguration engineConfiguration() {
        return this.engineConfiguration;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final MonitoringConfiguration monitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public final String notebookVersion() {
        return this.notebookVersion;
    }

    public final Integer sessionIdleTimeoutInMinutes() {
        return this.sessionIdleTimeoutInMinutes;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean copyWorkGroupTags() {
        return this.copyWorkGroupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionIdleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyWorkGroupTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionRequest)) {
            return false;
        }
        StartSessionRequest other = (StartSessionRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.engineConfiguration(), other.engineConfiguration()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.monitoringConfiguration(), other.monitoringConfiguration()) && Objects.equals(this.notebookVersion(), other.notebookVersion()) && Objects.equals(this.sessionIdleTimeoutInMinutes(), other.sessionIdleTimeoutInMinutes()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.copyWorkGroupTags(), other.copyWorkGroupTags());
    }

    public final String toString() {
        return ToString.builder((String)"StartSessionRequest").add("Description", (Object)this.description()).add("WorkGroup", (Object)this.workGroup()).add("EngineConfiguration", (Object)this.engineConfiguration()).add("ExecutionRole", (Object)this.executionRole()).add("MonitoringConfiguration", (Object)this.monitoringConfiguration()).add("NotebookVersion", (Object)this.notebookVersion()).add("SessionIdleTimeoutInMinutes", (Object)this.sessionIdleTimeoutInMinutes()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("CopyWorkGroupTags", (Object)this.copyWorkGroupTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "EngineConfiguration": {
                return Optional.ofNullable(clazz.cast(this.engineConfiguration()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfiguration()));
            }
            case "NotebookVersion": {
                return Optional.ofNullable(clazz.cast(this.notebookVersion()));
            }
            case "SessionIdleTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionIdleTimeoutInMinutes()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CopyWorkGroupTags": {
                return Optional.ofNullable(clazz.cast(this.copyWorkGroupTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("EngineConfiguration", ENGINE_CONFIGURATION_FIELD);
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("MonitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        map.put("NotebookVersion", NOTEBOOK_VERSION_FIELD);
        map.put("SessionIdleTimeoutInMinutes", SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CopyWorkGroupTags", COPY_WORK_GROUP_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSessionRequest, T> g) {
        return obj -> g.apply((StartSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String description;
        private String workGroup;
        private EngineConfiguration engineConfiguration;
        private String executionRole;
        private MonitoringConfiguration monitoringConfiguration;
        private String notebookVersion;
        private Integer sessionIdleTimeoutInMinutes;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean copyWorkGroupTags;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionRequest model) {
            super(model);
            this.description(model.description);
            this.workGroup(model.workGroup);
            this.engineConfiguration(model.engineConfiguration);
            this.executionRole(model.executionRole);
            this.monitoringConfiguration(model.monitoringConfiguration);
            this.notebookVersion(model.notebookVersion);
            this.sessionIdleTimeoutInMinutes(model.sessionIdleTimeoutInMinutes);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.copyWorkGroupTags(model.copyWorkGroupTags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final EngineConfiguration.Builder getEngineConfiguration() {
            return this.engineConfiguration != null ? this.engineConfiguration.toBuilder() : null;
        }

        public final void setEngineConfiguration(EngineConfiguration.BuilderImpl engineConfiguration) {
            this.engineConfiguration = engineConfiguration != null ? engineConfiguration.build() : null;
        }

        @Override
        public final Builder engineConfiguration(EngineConfiguration engineConfiguration) {
            this.engineConfiguration = engineConfiguration;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return this.monitoringConfiguration != null ? this.monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final String getNotebookVersion() {
            return this.notebookVersion;
        }

        public final void setNotebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
        }

        @Override
        public final Builder notebookVersion(String notebookVersion) {
            this.notebookVersion = notebookVersion;
            return this;
        }

        public final Integer getSessionIdleTimeoutInMinutes() {
            return this.sessionIdleTimeoutInMinutes;
        }

        public final void setSessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
        }

        @Override
        public final Builder sessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyWorkGroupTags() {
            return this.copyWorkGroupTags;
        }

        public final void setCopyWorkGroupTags(Boolean copyWorkGroupTags) {
            this.copyWorkGroupTags = copyWorkGroupTags;
        }

        @Override
        public final Builder copyWorkGroupTags(Boolean copyWorkGroupTags) {
            this.copyWorkGroupTags = copyWorkGroupTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSessionRequest build() {
            return new StartSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSessionRequest> {
        public Builder description(String var1);

        public Builder workGroup(String var1);

        public Builder engineConfiguration(EngineConfiguration var1);

        default public Builder engineConfiguration(Consumer<EngineConfiguration.Builder> engineConfiguration) {
            return this.engineConfiguration((EngineConfiguration)((EngineConfiguration.Builder)EngineConfiguration.builder().applyMutation(engineConfiguration)).build());
        }

        public Builder executionRole(String var1);

        public Builder monitoringConfiguration(MonitoringConfiguration var1);

        default public Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return this.monitoringConfiguration((MonitoringConfiguration)((MonitoringConfiguration.Builder)MonitoringConfiguration.builder().applyMutation(monitoringConfiguration)).build());
        }

        public Builder notebookVersion(String var1);

        public Builder sessionIdleTimeoutInMinutes(Integer var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder copyWorkGroupTags(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

