/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.DesiredConfiguration;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshProgressDetails;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshStatus;
import software.amazon.awssdk.services.autoscaling.model.RefreshPreferences;
import software.amazon.awssdk.services.autoscaling.model.RefreshStrategy;
import software.amazon.awssdk.services.autoscaling.model.RollbackDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRefresh
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRefresh> {
    private static final SdkField<String> INSTANCE_REFRESH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRefreshId").getter(InstanceRefresh.getter(InstanceRefresh::instanceRefreshId)).setter(InstanceRefresh.setter(Builder::instanceRefreshId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(InstanceRefresh.getter(InstanceRefresh::autoScalingGroupName)).setter(InstanceRefresh.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceRefresh.getter(InstanceRefresh::statusAsString)).setter(InstanceRefresh.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(InstanceRefresh.getter(InstanceRefresh::statusReason)).setter(InstanceRefresh.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(InstanceRefresh.getter(InstanceRefresh::startTime)).setter(InstanceRefresh.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(InstanceRefresh.getter(InstanceRefresh::endTime)).setter(InstanceRefresh.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentageComplete").getter(InstanceRefresh.getter(InstanceRefresh::percentageComplete)).setter(InstanceRefresh.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build()}).build();
    private static final SdkField<Integer> INSTANCES_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesToUpdate").getter(InstanceRefresh.getter(InstanceRefresh::instancesToUpdate)).setter(InstanceRefresh.setter(Builder::instancesToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdate").build()}).build();
    private static final SdkField<InstanceRefreshProgressDetails> PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressDetails").getter(InstanceRefresh.getter(InstanceRefresh::progressDetails)).setter(InstanceRefresh.setter(Builder::progressDetails)).constructor(InstanceRefreshProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressDetails").build()}).build();
    private static final SdkField<RefreshPreferences> PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Preferences").getter(InstanceRefresh.getter(InstanceRefresh::preferences)).setter(InstanceRefresh.setter(Builder::preferences)).constructor(RefreshPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferences").build()}).build();
    private static final SdkField<DesiredConfiguration> DESIRED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DesiredConfiguration").getter(InstanceRefresh.getter(InstanceRefresh::desiredConfiguration)).setter(InstanceRefresh.setter(Builder::desiredConfiguration)).constructor(DesiredConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredConfiguration").build()}).build();
    private static final SdkField<RollbackDetails> ROLLBACK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackDetails").getter(InstanceRefresh.getter(InstanceRefresh::rollbackDetails)).setter(InstanceRefresh.setter(Builder::rollbackDetails)).constructor(RollbackDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackDetails").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(InstanceRefresh.getter(InstanceRefresh::strategyAsString)).setter(InstanceRefresh.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESH_ID_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETE_FIELD, INSTANCES_TO_UPDATE_FIELD, PROGRESS_DETAILS_FIELD, PREFERENCES_FIELD, DESIRED_CONFIGURATION_FIELD, ROLLBACK_DETAILS_FIELD, STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceRefresh.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceRefreshId;
    private final String autoScalingGroupName;
    private final String status;
    private final String statusReason;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer percentageComplete;
    private final Integer instancesToUpdate;
    private final InstanceRefreshProgressDetails progressDetails;
    private final RefreshPreferences preferences;
    private final DesiredConfiguration desiredConfiguration;
    private final RollbackDetails rollbackDetails;
    private final String strategy;

    private InstanceRefresh(BuilderImpl builder) {
        this.instanceRefreshId = builder.instanceRefreshId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageComplete = builder.percentageComplete;
        this.instancesToUpdate = builder.instancesToUpdate;
        this.progressDetails = builder.progressDetails;
        this.preferences = builder.preferences;
        this.desiredConfiguration = builder.desiredConfiguration;
        this.rollbackDetails = builder.rollbackDetails;
        this.strategy = builder.strategy;
    }

    public final String instanceRefreshId() {
        return this.instanceRefreshId;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final InstanceRefreshStatus status() {
        return InstanceRefreshStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer percentageComplete() {
        return this.percentageComplete;
    }

    public final Integer instancesToUpdate() {
        return this.instancesToUpdate;
    }

    public final InstanceRefreshProgressDetails progressDetails() {
        return this.progressDetails;
    }

    public final RefreshPreferences preferences() {
        return this.preferences;
    }

    public final DesiredConfiguration desiredConfiguration() {
        return this.desiredConfiguration;
    }

    public final RollbackDetails rollbackDetails() {
        return this.rollbackDetails;
    }

    public final RefreshStrategy strategy() {
        return RefreshStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRefreshId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesToUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefresh)) {
            return false;
        }
        InstanceRefresh other = (InstanceRefresh)obj;
        return Objects.equals(this.instanceRefreshId(), other.instanceRefreshId()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.instancesToUpdate(), other.instancesToUpdate()) && Objects.equals(this.progressDetails(), other.progressDetails()) && Objects.equals(this.preferences(), other.preferences()) && Objects.equals(this.desiredConfiguration(), other.desiredConfiguration()) && Objects.equals(this.rollbackDetails(), other.rollbackDetails()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRefresh").add("InstanceRefreshId", (Object)this.instanceRefreshId()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PercentageComplete", (Object)this.percentageComplete()).add("InstancesToUpdate", (Object)this.instancesToUpdate()).add("ProgressDetails", (Object)this.progressDetails()).add("Preferences", (Object)this.preferences()).add("DesiredConfiguration", (Object)this.desiredConfiguration()).add("RollbackDetails", (Object)this.rollbackDetails()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceRefreshId": {
                return Optional.ofNullable(clazz.cast(this.instanceRefreshId()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "PercentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "InstancesToUpdate": {
                return Optional.ofNullable(clazz.cast(this.instancesToUpdate()));
            }
            case "ProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.progressDetails()));
            }
            case "Preferences": {
                return Optional.ofNullable(clazz.cast(this.preferences()));
            }
            case "DesiredConfiguration": {
                return Optional.ofNullable(clazz.cast(this.desiredConfiguration()));
            }
            case "RollbackDetails": {
                return Optional.ofNullable(clazz.cast(this.rollbackDetails()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceRefreshId", INSTANCE_REFRESH_ID_FIELD);
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("PercentageComplete", PERCENTAGE_COMPLETE_FIELD);
        map.put("InstancesToUpdate", INSTANCES_TO_UPDATE_FIELD);
        map.put("ProgressDetails", PROGRESS_DETAILS_FIELD);
        map.put("Preferences", PREFERENCES_FIELD);
        map.put("DesiredConfiguration", DESIRED_CONFIGURATION_FIELD);
        map.put("RollbackDetails", ROLLBACK_DETAILS_FIELD);
        map.put("Strategy", STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefresh, T> g) {
        return obj -> g.apply((InstanceRefresh)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceRefreshId;
        private String autoScalingGroupName;
        private String status;
        private String statusReason;
        private Instant startTime;
        private Instant endTime;
        private Integer percentageComplete;
        private Integer instancesToUpdate;
        private InstanceRefreshProgressDetails progressDetails;
        private RefreshPreferences preferences;
        private DesiredConfiguration desiredConfiguration;
        private RollbackDetails rollbackDetails;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefresh model) {
            this.instanceRefreshId(model.instanceRefreshId);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.percentageComplete(model.percentageComplete);
            this.instancesToUpdate(model.instancesToUpdate);
            this.progressDetails(model.progressDetails);
            this.preferences(model.preferences);
            this.desiredConfiguration(model.desiredConfiguration);
            this.rollbackDetails(model.rollbackDetails);
            this.strategy(model.strategy);
        }

        public final String getInstanceRefreshId() {
            return this.instanceRefreshId;
        }

        public final void setInstanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
        }

        @Override
        public final Builder instanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceRefreshStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPercentageComplete() {
            return this.percentageComplete;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final Integer getInstancesToUpdate() {
            return this.instancesToUpdate;
        }

        public final void setInstancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
        }

        @Override
        public final Builder instancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
            return this;
        }

        public final InstanceRefreshProgressDetails.Builder getProgressDetails() {
            return this.progressDetails != null ? this.progressDetails.toBuilder() : null;
        }

        public final void setProgressDetails(InstanceRefreshProgressDetails.BuilderImpl progressDetails) {
            this.progressDetails = progressDetails != null ? progressDetails.build() : null;
        }

        @Override
        public final Builder progressDetails(InstanceRefreshProgressDetails progressDetails) {
            this.progressDetails = progressDetails;
            return this;
        }

        public final RefreshPreferences.Builder getPreferences() {
            return this.preferences != null ? this.preferences.toBuilder() : null;
        }

        public final void setPreferences(RefreshPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(RefreshPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        public final DesiredConfiguration.Builder getDesiredConfiguration() {
            return this.desiredConfiguration != null ? this.desiredConfiguration.toBuilder() : null;
        }

        public final void setDesiredConfiguration(DesiredConfiguration.BuilderImpl desiredConfiguration) {
            this.desiredConfiguration = desiredConfiguration != null ? desiredConfiguration.build() : null;
        }

        @Override
        public final Builder desiredConfiguration(DesiredConfiguration desiredConfiguration) {
            this.desiredConfiguration = desiredConfiguration;
            return this;
        }

        public final RollbackDetails.Builder getRollbackDetails() {
            return this.rollbackDetails != null ? this.rollbackDetails.toBuilder() : null;
        }

        public final void setRollbackDetails(RollbackDetails.BuilderImpl rollbackDetails) {
            this.rollbackDetails = rollbackDetails != null ? rollbackDetails.build() : null;
        }

        @Override
        public final Builder rollbackDetails(RollbackDetails rollbackDetails) {
            this.rollbackDetails = rollbackDetails;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(RefreshStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public InstanceRefresh build() {
            return new InstanceRefresh(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRefresh> {
        public Builder instanceRefreshId(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder status(String var1);

        public Builder status(InstanceRefreshStatus var1);

        public Builder statusReason(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder percentageComplete(Integer var1);

        public Builder instancesToUpdate(Integer var1);

        public Builder progressDetails(InstanceRefreshProgressDetails var1);

        default public Builder progressDetails(Consumer<InstanceRefreshProgressDetails.Builder> progressDetails) {
            return this.progressDetails((InstanceRefreshProgressDetails)((InstanceRefreshProgressDetails.Builder)InstanceRefreshProgressDetails.builder().applyMutation(progressDetails)).build());
        }

        public Builder preferences(RefreshPreferences var1);

        default public Builder preferences(Consumer<RefreshPreferences.Builder> preferences) {
            return this.preferences((RefreshPreferences)((RefreshPreferences.Builder)RefreshPreferences.builder().applyMutation(preferences)).build());
        }

        public Builder desiredConfiguration(DesiredConfiguration var1);

        default public Builder desiredConfiguration(Consumer<DesiredConfiguration.Builder> desiredConfiguration) {
            return this.desiredConfiguration((DesiredConfiguration)((DesiredConfiguration.Builder)DesiredConfiguration.builder().applyMutation(desiredConfiguration)).build());
        }

        public Builder rollbackDetails(RollbackDetails var1);

        default public Builder rollbackDetails(Consumer<RollbackDetails.Builder> rollbackDetails) {
            return this.rollbackDetails((RollbackDetails)((RollbackDetails.Builder)RollbackDetails.builder().applyMutation(rollbackDetails)).build());
        }

        public Builder strategy(String var1);

        public Builder strategy(RefreshStrategy var1);
    }
}

